/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.fares.impl.AddingMultipleFareService;
import org.opentripplanner.routing.fares.impl.DefaultFareServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipleFareServiceFactory
implements FareServiceFactory {
    private static Logger log = LoggerFactory.getLogger(MultipleFareServiceFactory.class);
    private List<FareServiceFactory> subFactories;

    @Override
    public FareService makeFareService() {
        ArrayList<FareService> subServices = new ArrayList<FareService>();
        for (FareServiceFactory subFactory : this.subFactories) {
            subServices.add(subFactory.makeFareService());
        }
        return this.makeMultipleFareService(subServices);
    }

    protected abstract FareService makeMultipleFareService(List<FareService> var1);

    @Override
    public void processGtfs(OtpTransitService transitService) {
        for (FareServiceFactory subFactory : this.subFactories) {
            subFactory.processGtfs(transitService);
        }
    }

    @Override
    public void configure(JsonNode config) {
        this.subFactories = new ArrayList<FareServiceFactory>();
        for (JsonNode pConfig : config.path("fares")) {
            this.subFactories.add(DefaultFareServiceFactory.fromConfig(pConfig));
        }
        Iterator i = config.fields();
        while (i.hasNext()) {
            JsonNode node;
            FareServiceFactory fareFactory;
            Map.Entry kv = (Map.Entry)i.next();
            String key = (String)kv.getKey();
            if (!key.startsWith("fare") || key.equals("fares") || (fareFactory = DefaultFareServiceFactory.fromConfig(node = (JsonNode)kv.getValue())) == null) continue;
            this.subFactories.add(fareFactory);
        }
        if (this.subFactories.isEmpty()) {
            throw new IllegalArgumentException("Empty fare composite. Please specify either a 'fares' array or a list of 'fareXxx' properties");
        }
        if (this.subFactories.size() == 1) {
            log.warn("Fare composite has only ONE fare to combine. This is allowed, but useless. Did you forgot to define a second fare to combine?");
        }
    }

    public static class AddingMultipleFareServiceFactory
    extends MultipleFareServiceFactory {
        @Override
        protected FareService makeMultipleFareService(List<FareService> subServices) {
            return new AddingMultipleFareService(subServices);
        }
    }
}

