/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import java.util.Collection;
import java.util.Currency;
import java.util.List;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.routing.core.FareRuleSet;
import org.opentripplanner.routing.core.Money;
import org.opentripplanner.routing.fares.impl.DefaultFareServiceImpl;
import org.opentripplanner.routing.fares.impl.Ride;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DutchFareServiceImpl
extends DefaultFareServiceImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DutchFareServiceImpl.class);
    public static final int TRANSFER_DURATION = 2100;
    final Currency euros = Currency.getInstance("EUR");

    public DutchFareServiceImpl(Collection<FareRuleSet> regularFareRules) {
        this.addFareRules(Fare.FareType.regular, regularFareRules);
    }

    @Override
    protected boolean populateFare(Fare fare, Currency currency, Fare.FareType fareType, List<Ride> rides, Collection<FareRuleSet> fareRules) {
        float lowestCost = this.getLowestCost(fareType, rides, fareRules);
        if (lowestCost != Float.POSITIVE_INFINITY) {
            fare.addFare(fareType, DutchFareServiceImpl.getMoney(this.euros, lowestCost));
            return true;
        }
        return false;
    }

    private UnitsFareZone getUnitsByZones(FeedScopedId agencyId, String startZone, String endZone, Collection<FareRuleSet> fareRules) {
        P2<String> od = new P2<String>(startZone, endZone);
        LOG.trace("Search " + startZone + " and " + endZone);
        String fareIdStartsWith = agencyId.getId() + "::";
        for (FareRuleSet ruleSet : fareRules) {
            if (!ruleSet.getFareAttribute().getId().getId().startsWith(fareIdStartsWith) || !ruleSet.getOriginDestinations().contains(od)) continue;
            String fareId = ruleSet.getFareAttribute().getId().getId();
            String[] parts = fareId.split("::");
            String fareZone = parts[1];
            LOG.trace("Between " + startZone + " and " + endZone + ": " + (int)ruleSet.getFareAttribute().getPrice() + " (" + fareZone + ")");
            return new UnitsFareZone((int)ruleSet.getFareAttribute().getPrice(), fareZone);
        }
        LOG.warn("Can't find units between " + startZone + " and " + endZone);
        return null;
    }

    private float getCostByUnits(String fareZone, int units, int prevSumUnits, Collection<FareRuleSet> fareRules) {
        if (units == 0) {
            return 0.0f;
        }
        if (units > 250) {
            units = 250;
        }
        float cost = 0.0f;
        String fareId = fareZone + ":" + (units + prevSumUnits);
        for (FareRuleSet ruleSet : fareRules) {
            if (!ruleSet.getFareAttribute().getId().getId().equals(fareId)) continue;
            cost = ruleSet.getFareAttribute().getPrice();
            break;
        }
        if (cost == 0.0f) {
            LOG.warn("Can't find price for " + fareZone + " with " + units + " units");
        } else if (prevSumUnits > 0) {
            fareId = fareZone + ":" + prevSumUnits;
            for (FareRuleSet ruleSet : fareRules) {
                if (!ruleSet.getFareAttribute().getId().getId().equals(fareId)) continue;
                return cost -= ruleSet.getFareAttribute().getPrice();
            }
            LOG.warn("Can't find price for " + fareZone + " with " + prevSumUnits + " units");
            return Float.POSITIVE_INFINITY;
        }
        return cost;
    }

    private float getEasyTripFareByLineFromTo(String route, String firstStop, String lastStop, boolean entranceFee, Collection<FareRuleSet> fareRules) {
        float cost = Float.POSITIVE_INFINITY;
        String fareId = route + ":" + firstStop + "-" + lastStop;
        for (FareRuleSet ruleSet : fareRules) {
            if (!ruleSet.getFareAttribute().getId().getId().equals(fareId)) continue;
            cost = ruleSet.getFareAttribute().getPrice();
            break;
        }
        if (cost == Float.POSITIVE_INFINITY) {
            LOG.warn("Can't find price for " + firstStop + " to " + lastStop + " operated on " + route);
            return cost;
        }
        if (entranceFee) {
            cost += 90.0f;
        }
        return cost;
    }

    @Override
    public Fare getCost(Itinerary itinerary) {
        Currency euros = Currency.getInstance("EUR");
        Fare fare = super.getCost(itinerary);
        if (fare != null) {
            for (Money money : fare.fare.values()) {
                money.setCurrency(euros);
            }
        }
        return fare;
    }

    @Override
    protected float getLowestCost(Fare.FareType fareType, List<Ride> rides, Collection<FareRuleSet> fareRules) {
        float cost = 0.0f;
        int units = 0;
        int prevSumUnits = 0;
        boolean mustHaveCheckedOut = false;
        String startTariefEenheden = null;
        String endTariefEenheden = null;
        FeedScopedId lastAgencyId = null;
        String lastFareZone = null;
        long alightedEasyTrip = 0L;
        long alightedTariefEenheden = 0L;
        for (Ride ride : rides) {
            boolean entranceFee;
            LOG.trace(String.format("%s %s %s %s %s %s", ride.startZone, ride.endZone, ride.firstStop, ride.lastStop, ride.route, ride.agency));
            if (ride.agency.getFeedId().equals("IFF")) {
                LOG.trace("1. Trains");
                if ((mustHaveCheckedOut |= !ride.agency.equals(lastAgencyId)) && lastAgencyId != null) {
                    LOG.trace("2. Must have checked out from a station");
                    UnitsFareZone unitsFareZone = this.getUnitsByZones(lastAgencyId, startTariefEenheden, endTariefEenheden, fareRules);
                    if (unitsFareZone == null) {
                        return Float.POSITIVE_INFINITY;
                    }
                    lastFareZone = unitsFareZone.fareZone;
                    units += unitsFareZone.units;
                    startTariefEenheden = ride.startZone;
                    mustHaveCheckedOut = false;
                }
                if (alightedTariefEenheden + 2100L < ride.startTime.toEpochSecond()) {
                    LOG.trace("3. Exceeded Transfer Time");
                    if ((cost += this.getCostByUnits(lastFareZone, units, prevSumUnits, fareRules)) == Float.POSITIVE_INFINITY) {
                        return cost;
                    }
                    startTariefEenheden = ride.startZone;
                    units = 0;
                    prevSumUnits = 0;
                    mustHaveCheckedOut = false;
                } else if (!ride.agency.equals(lastAgencyId)) {
                    LOG.trace("4. Swiched Rail Agency");
                    if ((cost += this.getCostByUnits(lastFareZone, units, prevSumUnits, fareRules)) == Float.POSITIVE_INFINITY) {
                        return cost;
                    }
                    prevSumUnits += units;
                    units = 0;
                    startTariefEenheden = ride.startZone;
                }
                alightedTariefEenheden = ride.endTime.toEpochSecond();
                endTariefEenheden = ride.endZone;
                lastAgencyId = ride.agency;
                continue;
            }
            LOG.trace("5. Easy Trip");
            mustHaveCheckedOut = startTariefEenheden != null;
            boolean bl = entranceFee = alightedEasyTrip + 2100L < ride.startTime.toEpochSecond();
            if ((cost += this.getEasyTripFareByLineFromTo(ride.route.getId(), ride.startZone, ride.endZone, entranceFee, fareRules)) == Float.POSITIVE_INFINITY) {
                return cost;
            }
            alightedEasyTrip = ride.endTime.toEpochSecond();
        }
        LOG.trace("6. Final");
        if (lastAgencyId != null) {
            UnitsFareZone unitsFareZone = this.getUnitsByZones(lastAgencyId, startTariefEenheden, endTariefEenheden, fareRules);
            if (unitsFareZone == null) {
                return Float.POSITIVE_INFINITY;
            }
            lastFareZone = unitsFareZone.fareZone;
            cost += this.getCostByUnits(lastFareZone, units += unitsFareZone.units, prevSumUnits, fareRules);
        }
        if (cost == Float.POSITIVE_INFINITY) {
            return cost;
        }
        return cost / 100.0f;
    }

    private class UnitsFareZone {
        public int units;
        public String fareZone;

        public UnitsFareZone(int units, String fareZone) {
            this.units = units;
            this.fareZone = fareZone;
        }
    }
}

