/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opentripplanner.model.FareAttribute;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.routing.core.FareComponent;
import org.opentripplanner.routing.core.FareRuleSet;
import org.opentripplanner.routing.core.Money;
import org.opentripplanner.routing.core.WrappedCurrency;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.impl.FareAndId;
import org.opentripplanner.routing.fares.impl.FareSearch;
import org.opentripplanner.routing.fares.impl.Ride;
import org.opentripplanner.routing.fares.impl.RideMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFareServiceImpl
implements FareService {
    private static final long serialVersionUID = 20120229L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFareServiceImpl.class);
    protected Map<Fare.FareType, Collection<FareRuleSet>> fareRulesPerType = new HashMap<Fare.FareType, Collection<FareRuleSet>>();

    public void addFareRules(Fare.FareType fareType, Collection<FareRuleSet> fareRules) {
        this.fareRulesPerType.put(fareType, new ArrayList<FareRuleSet>(fareRules));
    }

    @Override
    public Fare getCost(Itinerary itinerary) {
        List<Ride> rides = RideMapper.ridesForItinerary(itinerary);
        if (rides.size() == 0) {
            return null;
        }
        Fare fare = new Fare();
        boolean hasFare = false;
        for (Map.Entry<Fare.FareType, Collection<FareRuleSet>> kv : this.fareRulesPerType.entrySet()) {
            Fare.FareType fareType = kv.getKey();
            Collection<FareRuleSet> fareRules = kv.getValue();
            Currency currency = null;
            if (fareRules.size() > 0) {
                currency = Currency.getInstance(fareRules.iterator().next().getFareAttribute().getCurrencyType());
            }
            hasFare = this.populateFare(fare, currency, fareType, rides, fareRules);
        }
        return hasFare ? fare : null;
    }

    protected static Money getMoney(Currency currency, float cost) {
        int fractionDigits = 2;
        if (currency != null) {
            fractionDigits = currency.getDefaultFractionDigits();
        }
        int cents = (int)Math.round((double)cost * Math.pow(10.0, fractionDigits));
        return new Money(new WrappedCurrency(currency), cents);
    }

    private FareSearch performSearch(Fare.FareType fareType, List<Ride> rides, Collection<FareRuleSet> fareRules) {
        FareSearch r = new FareSearch(rides.size());
        for (int i = 0; i < rides.size(); ++i) {
            for (int j = 0; j < rides.size() - i; ++j) {
                FareAndId best = this.getBestFareAndId(fareType, rides.subList(j, j + i + 1), fareRules);
                float cost = best.fare;
                if (cost < 0.0f) {
                    LOG.error("negative cost for a ride sequence");
                    cost = Float.POSITIVE_INFINITY;
                }
                if (cost < Float.POSITIVE_INFINITY) {
                    r.endOfComponent[j] = j + i;
                    r.next[j][j + i] = j + i;
                }
                r.resultTable[j][j + i] = cost;
                r.fareIds[j][j + i] = best.fareId;
                for (int k = 0; k < i; ++k) {
                    float via = this.addFares(rides.subList(j, j + k + 1), rides.subList(j + k + 1, j + i + 1), r.resultTable[j][j + k], r.resultTable[j + k + 1][j + i]);
                    if (!(r.resultTable[j][j + i] > via)) continue;
                    r.resultTable[j][j + i] = via;
                    r.endOfComponent[j] = j + i;
                    r.next[j][j + i] = r.next[j][j + k];
                }
            }
        }
        return r;
    }

    protected float addFares(List<Ride> ride0, List<Ride> ride1, float cost0, float cost1) {
        return cost0 + cost1;
    }

    protected float getLowestCost(Fare.FareType fareType, List<Ride> rides, Collection<FareRuleSet> fareRules) {
        FareSearch r = this.performSearch(fareType, rides, fareRules);
        return r.resultTable[0][rides.size() - 1];
    }

    protected boolean populateFare(Fare fare, Currency currency, Fare.FareType fareType, List<Ride> rides, Collection<FareRuleSet> fareRules) {
        FareSearch r = this.performSearch(fareType, rides, fareRules);
        ArrayList<FareComponent> details = new ArrayList<FareComponent>();
        int count = 0;
        int start = 0;
        int end = rides.size() - 1;
        while (start <= end) {
            while (start <= end && r.endOfComponent[start] < 0) {
                ++start;
            }
            if (start > end) break;
            int via = r.next[start][r.endOfComponent[start]];
            float cost = r.resultTable[start][via];
            FeedScopedId fareId = r.fareIds[start][via];
            FareComponent detail = new FareComponent(fareId, DefaultFareServiceImpl.getMoney(currency, cost));
            for (int i = start; i <= via; ++i) {
                detail.addRoute(rides.get((int)i).route);
            }
            details.add(detail);
            ++count;
            start = via + 1;
        }
        fare.addFare(fareType, DefaultFareServiceImpl.getMoney(currency, r.resultTable[0][rides.size() - 1]));
        fare.addFareDetails(fareType, details);
        return count > 0;
    }

    protected float calculateCost(Fare.FareType fareType, List<Ride> rides, Collection<FareRuleSet> fareRules) {
        return this.getBestFareAndId((Fare.FareType)fareType, rides, fareRules).fare;
    }

    private FareAndId getBestFareAndId(Fare.FareType fareType, List<Ride> rides, Collection<FareRuleSet> fareRules) {
        HashSet<String> zones = new HashSet<String>();
        HashSet<FeedScopedId> routes = new HashSet<FeedScopedId>();
        HashSet<FeedScopedId> trips = new HashSet<FeedScopedId>();
        int transfersUsed = -1;
        Ride firstRide = rides.get(0);
        ZonedDateTime startTime = firstRide.startTime;
        String startZone = firstRide.startZone;
        String endZone = firstRide.endZone;
        String feedId = firstRide.firstStop.getId().getFeedId();
        ZonedDateTime lastRideStartTime = firstRide.startTime;
        ZonedDateTime lastRideEndTime = firstRide.endTime;
        for (Ride ride : rides) {
            if (!ride.firstStop.getId().getFeedId().equals(feedId)) {
                LOG.debug("skipped multi-feed ride sequence {}", rides);
                return new FareAndId(Float.POSITIVE_INFINITY, null);
            }
            lastRideStartTime = ride.startTime;
            lastRideEndTime = ride.endTime;
            endZone = ride.endZone;
            routes.add(ride.route);
            zones.addAll(ride.zones);
            trips.add(ride.trip);
            ++transfersUsed;
        }
        TransitEntity bestAttribute = null;
        float bestFare = Float.POSITIVE_INFINITY;
        Duration tripTime = Duration.between(startTime, lastRideStartTime);
        Duration journeyTime = Duration.between(startTime, lastRideEndTime);
        for (FareRuleSet ruleSet : fareRules) {
            float newFare;
            FareAttribute attribute = ruleSet.getFareAttribute();
            if (!attribute.getId().getFeedId().equals(feedId) || !ruleSet.matches(startZone, endZone, zones, routes, trips) || attribute.isTransfersSet() && attribute.getTransfers() < transfersUsed || attribute.isTransferDurationSet() && tripTime.getSeconds() > (long)attribute.getTransferDuration() || attribute.isJourneyDurationSet() && journeyTime.getSeconds() > (long)attribute.getJourneyDuration() || !((newFare = this.getFarePrice(attribute, fareType)) < bestFare)) continue;
            bestAttribute = attribute;
            bestFare = newFare;
        }
        LOG.debug("{} best for {}", bestAttribute, rides);
        if (bestFare == Float.POSITIVE_INFINITY) {
            LOG.debug("No fare for a ride sequence: {}", rides);
        }
        return new FareAndId(bestFare, bestAttribute == null ? null : bestAttribute.getId());
    }

    private float getFarePrice(FareAttribute fare, Fare.FareType type) {
        switch (type) {
            case senior: {
                if (!(fare.getSeniorPrice() >= 0.0f)) break;
                return fare.getSeniorPrice();
            }
            case youth: {
                if (!(fare.getYouthPrice() >= 0.0f)) break;
                return fare.getYouthPrice();
            }
        }
        return fare.getPrice();
    }
}

