/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.model.FareAttribute;
import org.opentripplanner.model.FareRule;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.Route;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.routing.core.FareRuleSet;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.fares.impl.DefaultFareServiceImpl;
import org.opentripplanner.routing.fares.impl.DutchFareServiceFactory;
import org.opentripplanner.routing.fares.impl.MultipleFareServiceFactory;
import org.opentripplanner.routing.fares.impl.NoopFareServiceFactory;
import org.opentripplanner.routing.fares.impl.NycFareServiceFactory;
import org.opentripplanner.routing.fares.impl.SFBayFareServiceFactory;
import org.opentripplanner.routing.fares.impl.SeattleFareServiceFactory;
import org.opentripplanner.routing.fares.impl.TimeBasedVehicleRentalFareServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFareServiceFactory
implements FareServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFareServiceFactory.class);
    protected Map<FeedScopedId, FareRuleSet> regularFareRules = new HashMap<FeedScopedId, FareRuleSet>();

    @Override
    public FareService makeFareService() {
        DefaultFareServiceImpl fareService = new DefaultFareServiceImpl();
        fareService.addFareRules(Fare.FareType.regular, this.regularFareRules.values());
        return fareService;
    }

    @Override
    public void processGtfs(OtpTransitService transitService) {
        this.fillFareRules(transitService.getAllFareAttributes(), transitService.getAllFareRules(), this.regularFareRules);
    }

    protected void fillFareRules(Collection<FareAttribute> fareAttributes, Collection<FareRule> fareRules, Map<FeedScopedId, FareRuleSet> fareRuleSet) {
        for (FareAttribute fare : fareAttributes) {
            FeedScopedId id = fare.getId();
            FareRuleSet fareRule = fareRuleSet.get(id);
            if (fareRule != null) continue;
            fareRule = new FareRuleSet(fare);
            fareRuleSet.put(id, fareRule);
        }
        for (FareRule rule : fareRules) {
            Route route;
            FareAttribute fare = rule.getFare();
            FeedScopedId id = fare.getId();
            FareRuleSet fareRule = fareRuleSet.get(id);
            if (fareRule == null) {
                LOG.error("Inexistant fare ID in fare rule: " + id);
                continue;
            }
            String contains = rule.getContainsId();
            if (contains != null) {
                fareRule.addContains(contains);
            }
            String origin = rule.getOriginId();
            String destination = rule.getDestinationId();
            if (origin != null || destination != null) {
                fareRule.addOriginDestination(origin, destination);
            }
            if ((route = rule.getRoute()) == null) continue;
            FeedScopedId routeId = route.getId();
            fareRule.addRoute(routeId);
        }
    }

    @Override
    public void configure(JsonNode config) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static FareServiceFactory fromConfig(JsonNode config) {
        Object type = null;
        if (config == null) {
            type = null;
        } else if (config.isTextual()) {
            type = config.asText();
        } else if (config.has("combinationStrategy")) {
            String combinationStrategy;
            switch (combinationStrategy = config.path("combinationStrategy").asText()) {
                case "additive": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown fare combinationStrategy: " + combinationStrategy);
                }
            }
            type = "composite:" + combinationStrategy;
        } else if (config.has("type")) {
            type = config.path("type").asText(null);
        }
        if (type == null) {
            type = "default";
        }
        FareServiceFactory factory = DefaultFareServiceFactory.createFactory((String)type);
        factory.configure(config);
        return factory;
    }

    private static FareServiceFactory createFactory(String type) {
        switch (type) {
            case "default": {
                return new DefaultFareServiceFactory();
            }
            case "off": {
                return new NoopFareServiceFactory();
            }
            case "composite:additive": {
                return new MultipleFareServiceFactory.AddingMultipleFareServiceFactory();
            }
            case "vehicle-rental-time-based": 
            case "bike-rental-time-based": {
                return new TimeBasedVehicleRentalFareServiceFactory();
            }
            case "dutch": {
                return new DutchFareServiceFactory();
            }
            case "san-francisco": {
                return new SFBayFareServiceFactory();
            }
            case "new-york": {
                return new NycFareServiceFactory();
            }
            case "seattle": {
                return new SeattleFareServiceFactory();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown fare type: '%s'", type));
    }
}

