/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.fares.impl;

import java.io.Serializable;
import java.util.List;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.routing.core.Money;
import org.opentripplanner.routing.fares.FareService;

public class AddingMultipleFareService
implements FareService,
Serializable {
    private static final long serialVersionUID = -5313317664330954335L;
    private List<FareService> subServices;

    protected AddingMultipleFareService(List<FareService> subServices) {
        this.subServices = subServices;
    }

    @Override
    public Fare getCost(Itinerary itinerary) {
        Fare fare = null;
        for (FareService subService : this.subServices) {
            Fare subFare = subService.getCost(itinerary);
            if (subFare == null) continue;
            if (fare == null) {
                fare = new Fare(subFare);
                continue;
            }
            Fare newFare = new Fare(fare);
            for (Fare.FareType fareType : Fare.FareType.values()) {
                Money cost = fare.getFare(fareType);
                Money subCost = subFare.getFare(fareType);
                if (cost == null && subCost == null) continue;
                if (cost != null && subCost == null) {
                    subCost = subFare.getFare(Fare.FareType.regular);
                } else if (cost == null && subCost != null) {
                    cost = fare.getFare(Fare.FareType.regular);
                }
                if (cost != null && subCost != null) {
                    newFare.addFare(fareType, cost.getCurrency(), cost.getCents() + subCost.getCents());
                    continue;
                }
                if (cost != null || subCost == null) continue;
                newFare.addFare(fareType, subCost.getCurrency(), subCost.getCents());
            }
            fare = newFare;
        }
        return fare;
    }
}

