/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vertextype.VehicleRentalStationVertex;
import org.opentripplanner.util.I18NString;

public class VehicleRentalEdge
extends Edge {
    private static final long serialVersionUID = 1L;
    public RentalVehicleType.FormFactor formFactor;

    public VehicleRentalEdge(VehicleRentalStationVertex vertex, RentalVehicleType.FormFactor formFactor) {
        super(vertex, vertex);
        this.formFactor = formFactor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public State traverse(State s0) {
        boolean pickedUp;
        RoutingRequest options;
        StateEditor s1;
        block26: {
            boolean realtimeAvailability;
            String network;
            VehicleRentalPlace station;
            block25: {
                if (!s0.getOptions().vehicleRental) {
                    return null;
                }
                if (!s0.getOptions().allowedRentalFormFactors.isEmpty() && !s0.getOptions().allowedRentalFormFactors.contains((Object)this.formFactor)) {
                    return null;
                }
                s1 = s0.edit(this);
                options = s0.getOptions();
                VehicleRentalStationVertex stationVertex = (VehicleRentalStationVertex)this.tov;
                station = stationVertex.getStation();
                network = station.getNetwork();
                realtimeAvailability = options.useVehicleRentalAvailabilityInformation;
                if (station.networkIsNotAllowed(s0.getOptions())) {
                    return null;
                }
                if (!options.arriveBy) break block25;
                switch (s0.getVehicleRentalState()) {
                    case BEFORE_RENTING: {
                        return null;
                    }
                    case HAVE_RENTED: {
                        if (!(!realtimeAvailability || station.allowDropoffNow() && station.getAvailableDropoffFormFactors(true).contains((Object)this.formFactor))) {
                            return null;
                        }
                        s1.dropOffRentedVehicleAtStation(this.formFactor, network, true);
                        pickedUp = false;
                        break block26;
                    }
                    case RENTING_FLOATING: {
                        if (realtimeAvailability && !station.getAvailablePickupFormFactors(true).contains((Object)this.formFactor)) {
                            return null;
                        }
                        if (!station.isFloatingVehicle()) return null;
                        s1.beginFloatingVehicleRenting(this.formFactor, network, true);
                        pickedUp = true;
                        break block26;
                    }
                    case RENTING_FROM_STATION: {
                        if (!(!realtimeAvailability || station.allowPickupNow() && station.getAvailablePickupFormFactors(true).contains((Object)this.formFactor))) {
                            return null;
                        }
                        if (s0.mayKeepRentedVehicleAtDestination() && !station.isKeepingVehicleRentalAtDestinationAllowed()) {
                            return null;
                        }
                        if (!this.hasCompatibleNetworks(network, s0.getVehicleRentalNetwork())) {
                            return null;
                        }
                        s1.beginVehicleRentingAtStation(this.formFactor, network, false, true);
                        pickedUp = true;
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            switch (s0.getVehicleRentalState()) {
                case BEFORE_RENTING: {
                    if (!(!realtimeAvailability || station.allowPickupNow() && station.getAvailablePickupFormFactors(true).contains((Object)this.formFactor))) {
                        return null;
                    }
                    if (station.isFloatingVehicle()) {
                        s1.beginFloatingVehicleRenting(this.formFactor, network, false);
                    } else {
                        boolean mayKeep = options.allowKeepingRentedVehicleAtDestination && station.isKeepingVehicleRentalAtDestinationAllowed();
                        s1.beginVehicleRentingAtStation(this.formFactor, network, mayKeep, false);
                    }
                    pickedUp = true;
                    break;
                }
                case HAVE_RENTED: {
                    return null;
                }
                case RENTING_FLOATING: 
                case RENTING_FROM_STATION: {
                    if (!this.hasCompatibleNetworks(network, s0.getVehicleRentalNetwork())) {
                        return null;
                    }
                    if (!(!realtimeAvailability || station.allowDropoffNow() && station.getAvailableDropoffFormFactors(true).contains((Object)this.formFactor))) {
                        return null;
                    }
                    if (!options.allowedRentalFormFactors.isEmpty() && station.getAvailableDropoffFormFactors(realtimeAvailability).stream().noneMatch(formFactor -> options.allowedRentalFormFactors.contains(formFactor))) {
                        return null;
                    }
                    s1.dropOffRentedVehicleAtStation(this.formFactor, network, false);
                    pickedUp = false;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        s1.incrementWeight(pickedUp ? (double)options.vehicleRentalPickupCost : (double)options.vehicleRentalDropoffCost);
        s1.incrementTimeInSeconds(pickedUp ? options.vehicleRentalPickupTime : options.vehicleRentalDropoffTime);
        s1.setBackMode(null);
        return s1.makeState();
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public I18NString getName() {
        return this.getToVertex().getName();
    }

    @Override
    public boolean hasBogusName() {
        return false;
    }

    private boolean hasCompatibleNetworks(String stationNetwork, String rentedNetwork) {
        if (rentedNetwork == null) {
            return true;
        }
        return rentedNetwork.equals(stationNetwork);
    }
}

