/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.util.I18NString;

public class VehicleParkingEdge
extends Edge {
    private static final long serialVersionUID = 1L;
    private final VehicleParking vehicleParking;

    public VehicleParkingEdge(VehicleParkingEntranceVertex vehicleParkingEntranceVertex) {
        this(vehicleParkingEntranceVertex, vehicleParkingEntranceVertex);
    }

    public VehicleParkingEdge(VehicleParkingEntranceVertex fromVehicleParkingEntranceVertex, VehicleParkingEntranceVertex toVehicleParkingEntranceVertex) {
        super(fromVehicleParkingEntranceVertex, toVehicleParkingEntranceVertex);
        this.vehicleParking = fromVehicleParkingEntranceVertex.getVehicleParking();
    }

    public VehicleParking getVehicleParking() {
        return this.vehicleParking;
    }

    @Override
    public State traverse(State s0) {
        RoutingRequest options = s0.getOptions();
        if (!options.parkAndRide) {
            return null;
        }
        if (options.arriveBy) {
            return this.traverseUnPark(s0);
        }
        return this.traversePark(s0);
    }

    protected State traverseUnPark(State s0) {
        RoutingRequest options = s0.getOptions();
        if (s0.getNonTransitMode() != TraverseMode.WALK || !s0.isVehicleParked()) {
            return null;
        }
        if (options.streetSubRequestModes.getBicycle()) {
            return this.traverseUnPark(s0, options.bikeParkCost, options.bikeParkTime, TraverseMode.BICYCLE);
        }
        if (options.streetSubRequestModes.getCar()) {
            return this.traverseUnPark(s0, options.carParkCost, options.carParkTime, TraverseMode.CAR);
        }
        return null;
    }

    private State traverseUnPark(State s0, int parkingCost, int parkingTime, TraverseMode mode) {
        RoutingRequest options = s0.getOptions();
        if (!this.vehicleParking.hasSpacesAvailable(mode, options.wheelchairAccessible, options.useVehicleParkingAvailabilityInformation)) {
            return null;
        }
        StateEditor s0e = s0.edit(this);
        s0e.incrementWeight(parkingCost);
        s0e.incrementTimeInSeconds(parkingTime);
        s0e.setVehicleParked(false, mode);
        return s0e.makeState();
    }

    private State traversePark(State s0) {
        RoutingRequest options = s0.getOptions();
        if (!options.streetSubRequestModes.getWalk() || s0.isVehicleParked()) {
            return null;
        }
        if (options.streetSubRequestModes.getBicycle()) {
            if (s0.isRentingVehicle()) {
                return null;
            }
            return this.traversePark(s0, options.bikeParkCost, options.bikeParkTime);
        }
        if (options.streetSubRequestModes.getCar()) {
            return this.traversePark(s0, options.carParkCost, options.carParkTime);
        }
        return null;
    }

    private State traversePark(State s0, int parkingCost, int parkingTime) {
        RoutingRequest options = s0.getOptions();
        if (!this.vehicleParking.hasSpacesAvailable(s0.getNonTransitMode(), options.wheelchairAccessible, options.useVehicleParkingAvailabilityInformation)) {
            return null;
        }
        StateEditor s0e = s0.edit(this);
        s0e.incrementWeight(parkingCost);
        s0e.incrementTimeInSeconds(parkingTime);
        s0e.setVehicleParked(true, TraverseMode.WALK);
        return s0e.makeState();
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public I18NString getName() {
        return this.getToVertex().getName();
    }

    @Override
    public boolean hasBogusName() {
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof VehicleParkingEdge) {
            VehicleParkingEdge other = (VehicleParkingEdge)o;
            return other.getFromVertex().equals(this.fromv) && other.getToVertex().equals(this.tov);
        }
        return false;
    }

    @Override
    public String toString() {
        return "VehicleParkingEdge(" + this.fromv + " -> " + this.tov + ")";
    }
}

