/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.TurnRestriction;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetWithElevationEdge;
import org.opentripplanner.routing.edgetype.TemporaryEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.util.ElevationUtils;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.TemporaryVertex;
import org.opentripplanner.util.I18NString;

public final class TemporaryPartialStreetEdge
extends StreetWithElevationEdge
implements TemporaryEdge {
    private static final long serialVersionUID = 1L;
    private final StreetEdge parentEdge;
    private final LineString geometry;

    public TemporaryPartialStreetEdge(StreetEdge parentEdge, StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name, double length) {
        super(v1, v2, geometry, name, length, parentEdge.getPermission(), false);
        this.parentEdge = parentEdge;
        this.geometry = super.getGeometry();
        this.setCarSpeed(parentEdge.getCarSpeed());
        this.setElevationProfileUsingParents();
    }

    TemporaryPartialStreetEdge(StreetEdge parentEdge, StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name) {
        super(v1, v2, geometry, name, parentEdge.getPermission(), false);
        this.parentEdge = parentEdge;
        this.geometry = super.getGeometry();
        this.setCarSpeed(parentEdge.getCarSpeed());
        this.setElevationProfileUsingParents();
    }

    @Override
    public LineString getGeometry() {
        return this.geometry;
    }

    @Override
    public boolean isPartial() {
        return true;
    }

    @Override
    public int getInAngle() {
        return this.parentEdge.getInAngle();
    }

    @Override
    public int getOutAngle() {
        return this.parentEdge.getInAngle();
    }

    @Override
    @Nonnull
    public Collection<TurnRestriction> getTurnRestrictions() {
        return this.parentEdge.getTurnRestrictions();
    }

    @Override
    public boolean isEquivalentTo(Edge e) {
        return e == this || e == this.parentEdge;
    }

    @Override
    public boolean isReverseOf(Edge e) {
        Edge other = e;
        if (e instanceof TemporaryPartialStreetEdge) {
            other = ((TemporaryPartialStreetEdge)e).parentEdge;
        }
        return this.parentEdge.isReverseOf(other);
    }

    @Override
    public boolean isRoundabout() {
        return this.parentEdge.isRoundabout();
    }

    public boolean isTrivial() {
        Coordinate fromCoord = this.getFromVertex().getCoordinate();
        Coordinate toCoord = this.getToVertex().getCoordinate();
        return fromCoord.equals((Object)toCoord);
    }

    public StreetEdge getParentEdge() {
        return this.parentEdge;
    }

    @Override
    public String toString() {
        return "TemporaryPartialStreetEdge(" + this.getDefaultName() + ", " + this.getFromVertex() + " -> " + this.getToVertex() + " length=" + this.getDistanceMeters() + " carSpeed=" + this.getCarSpeed() + " parentEdge=" + this.parentEdge + ")";
    }

    private void assertEdgeIsNotDirectedAwayFromTemporaryEndVertex(StreetVertex v1) {
        if (v1 instanceof TemporaryVertex && ((TemporaryVertex)((Object)v1)).isEndVertex()) {
            throw new IllegalStateException("A temporary edge is directed away from an end vertex");
        }
    }

    private void assertEdgeIsDirectedTowardsTemporaryEndVertex(StreetVertex v2) {
        if (v2 instanceof TemporaryVertex && !((TemporaryVertex)((Object)v2)).isEndVertex()) {
            throw new IllegalStateException("A temporary edge is directed towards a start vertex");
        }
    }

    private void setElevationProfileUsingParents() {
        this.setElevationProfile(ElevationUtils.getPartialElevationProfile(this.getParentEdge().getElevationProfile(), 0.0, this.getDistanceMeters()), false);
    }
}

