/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.CompactElevationProfile;
import org.opentripplanner.common.geometry.PackedCoordinateSequence;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.util.ElevationUtils;
import org.opentripplanner.routing.util.SlopeCosts;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;

public class StreetWithElevationEdge
extends StreetEdge {
    private static final long serialVersionUID = 1L;
    private double effectiveWalkDistanceFactor = 1.0;
    private double effectiveBikeDistanceFactor = 1.0;
    private double effectiveBikeWorkFactor = 1.0;
    private byte[] packedElevationProfile;
    private float maxSlope;
    private boolean flattened;

    public StreetWithElevationEdge(StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name, double length, StreetTraversalPermission permission, boolean back) {
        super(v1, v2, geometry, name, length, permission, back);
    }

    public StreetWithElevationEdge(StreetVertex v1, StreetVertex v2, LineString geometry, String name, double length, StreetTraversalPermission permission, boolean back) {
        this(v1, v2, geometry, new NonLocalizedString(name), length, permission, back);
    }

    public StreetWithElevationEdge(StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name, StreetTraversalPermission permission, boolean back) {
        super(v1, v2, geometry, name, permission, back);
    }

    @Override
    public StreetWithElevationEdge clone() {
        return (StreetWithElevationEdge)super.clone();
    }

    public boolean setElevationProfile(PackedCoordinateSequence elev, boolean computed) {
        if (elev == null || elev.size() < 2) {
            return false;
        }
        if (super.isSlopeOverride() && !computed) {
            return false;
        }
        boolean slopeLimit = this.getPermission().allows(StreetTraversalPermission.CAR);
        SlopeCosts costs = ElevationUtils.getSlopeCosts(elev, slopeLimit);
        this.packedElevationProfile = CompactElevationProfile.compactElevationProfileWithRegularSamples(elev);
        this.effectiveBikeDistanceFactor = costs.slopeSpeedFactor;
        this.effectiveBikeWorkFactor = costs.slopeWorkFactor;
        this.maxSlope = (float)costs.maxSlope;
        this.flattened = costs.flattened;
        this.effectiveWalkDistanceFactor = costs.effectiveWalkFactor;
        this.bicycleSafetyFactor = (float)((double)this.bicycleSafetyFactor * costs.lengthMultiplier);
        this.bicycleSafetyFactor = (float)((double)this.bicycleSafetyFactor + costs.slopeSafetyCost / this.getDistanceMeters());
        return costs.flattened;
    }

    @Override
    public PackedCoordinateSequence getElevationProfile() {
        return CompactElevationProfile.uncompactElevationProfileWithRegularSamples(this.packedElevationProfile, this.getDistanceMeters());
    }

    public boolean hasPackedElevationProfile() {
        return this.packedElevationProfile != null;
    }

    @Override
    public boolean isElevationFlattened() {
        return this.flattened;
    }

    @Override
    public float getMaxSlope() {
        return this.maxSlope;
    }

    @Override
    public double getEffectiveBikeDistance() {
        return (this.isStairs() ? 1.0 : this.effectiveWalkDistanceFactor) * this.getDistanceMeters();
    }

    @Override
    public double getEffectiveBikeWorkCost() {
        return this.effectiveBikeWorkFactor * this.getDistanceMeters();
    }

    @Override
    public double getEffectiveWalkDistance() {
        return (this.isStairs() ? 1.0 : this.effectiveWalkDistanceFactor) * this.getDistanceMeters();
    }

    @Override
    public String toString() {
        return "StreetWithElevationEdge(" + this.getDefaultName() + ", " + this.fromv + " -> " + this.tov + " length=" + this.getDistanceMeters() + " carSpeed=" + this.getCarSpeed() + " permission=" + this.getPermission() + ")";
    }
}

