/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalStationVertex;
import org.opentripplanner.util.I18NString;

public class StreetVehicleRentalLink
extends Edge {
    private static final long serialVersionUID = 1L;
    private VehicleRentalStationVertex vehicleRentalStationVertex;

    public StreetVehicleRentalLink(StreetVertex fromv, VehicleRentalStationVertex tov) {
        super(fromv, tov);
        this.vehicleRentalStationVertex = tov;
    }

    public StreetVehicleRentalLink(VehicleRentalStationVertex fromv, StreetVertex tov) {
        super(fromv, tov);
        this.vehicleRentalStationVertex = fromv;
    }

    @Override
    public String getDirection() {
        return null;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public I18NString getName() {
        return this.vehicleRentalStationVertex.getName();
    }

    @Override
    public State traverse(State s0) {
        if (s0.getBackEdge() instanceof StreetVehicleRentalLink) {
            return null;
        }
        if (this.vehicleRentalStationVertex.getStation().networkIsNotAllowed(s0.getOptions())) {
            return null;
        }
        StateEditor s1 = s0.edit(this);
        s1.incrementWeight(1.0);
        s1.setBackMode(null);
        return s1.makeState();
    }

    @Override
    public Vertex getFromVertex() {
        return this.fromv;
    }

    @Override
    public Vertex getToVertex() {
        return this.tov;
    }

    @Override
    public String toString() {
        return "StreetVehicleRentalLink(" + this.fromv + " -> " + this.tov + ")";
    }
}

