/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.model.Trip;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.edgetype.CarPickupableEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.util.I18NString;

public abstract class StreetTransitEntityLink<T extends Vertex>
extends Edge
implements CarPickupableEdge {
    private static final long serialVersionUID = -3311099256178798981L;
    static final int STEL_TRAVERSE_COST = 1;
    private final T transitEntityVertex;
    private final boolean wheelchairAccessible;

    public StreetTransitEntityLink(StreetVertex fromv, T tov, boolean wheelchairAccessible) {
        super(fromv, (Vertex)tov);
        this.transitEntityVertex = tov;
        this.wheelchairAccessible = wheelchairAccessible;
    }

    public StreetTransitEntityLink(T fromv, StreetVertex tov, boolean wheelchairAccessible) {
        super((Vertex)fromv, tov);
        this.transitEntityVertex = fromv;
        this.wheelchairAccessible = wheelchairAccessible;
    }

    protected abstract int getStreetToStopTime();

    protected T getTransitEntityVertex() {
        return this.transitEntityVertex;
    }

    @Override
    public String getDirection() {
        return null;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    @Override
    public LineString getGeometry() {
        Coordinate[] coordinates = new Coordinate[]{this.fromv.getCoordinate(), this.tov.getCoordinate()};
        return GeometryUtils.getGeometryFactory().createLineString(coordinates);
    }

    @Override
    public I18NString getName() {
        return ((Vertex)this.transitEntityVertex).getName();
    }

    @Override
    public State traverse(State s0) {
        if (s0.backEdge instanceof StreetTransitEntityLink && ((StreetTransitEntityLink)s0.backEdge).transitEntityVertex == this.transitEntityVertex) {
            return null;
        }
        RoutingRequest req = s0.getOptions();
        if (s0.getOptions().wheelchairAccessible && !this.wheelchairAccessible) {
            return null;
        }
        StateEditor s1 = s0.edit(this);
        switch (s0.getNonTransitMode()) {
            case BICYCLE: {
                if (s0.getOptions().parkAndRide && !s0.isVehicleParked()) {
                    return null;
                }
                if (!s0.isRentingVehicleFromStation() || s0.mayKeepRentedVehicleAtDestination() && s0.getOptions().allowKeepingRentedVehicleAtDestination) break;
                return null;
            }
            case CAR: {
                if (s0.getOptions().parkAndRide && !s0.isVehicleParked()) {
                    return null;
                }
                if (s0.getCarPickupState() == null) break;
                if (this.canDropOffAfterDriving(s0) && this.isLeavingStreetNetwork(req)) {
                    this.dropOffAfterDriving(s0, s1);
                    break;
                }
                return null;
            }
            case WALK: {
                break;
            }
            default: {
                return null;
            }
        }
        if (s0.isRentingVehicleFromStation() && s0.mayKeepRentedVehicleAtDestination() && s0.getOptions().allowKeepingRentedVehicleAtDestination) {
            s1.incrementWeight(s0.getOptions().keepingRentedVehicleAtDestinationCost);
        }
        s1.setBackMode(null);
        int streetToStopTime = this.getStreetToStopTime();
        s1.incrementTimeInSeconds(streetToStopTime);
        s1.incrementWeight(1 + streetToStopTime);
        return s1.makeState();
    }

    boolean isLeavingStreetNetwork(RoutingRequest req) {
        return (req.arriveBy ? this.fromv : this.tov) == this.getTransitEntityVertex();
    }

    @Override
    public Vertex getFromVertex() {
        return this.fromv;
    }

    @Override
    public Vertex getToVertex() {
        return this.tov;
    }

    @Override
    public Trip getTrip() {
        return null;
    }

    @Override
    public boolean isRoundabout() {
        return false;
    }

    @Override
    public String toString() {
        return "StreetTransitLink(" + this.fromv + " -> " + this.tov + ")";
    }
}

