/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.TurnRestriction;
import org.opentripplanner.common.TurnRestrictionType;
import org.opentripplanner.common.geometry.CompactLineString;
import org.opentripplanner.common.geometry.DirectionUtils;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.common.geometry.PackedCoordinateSequence;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.graph_builder.linking.DisposableEdgeCollection;
import org.opentripplanner.graph_builder.linking.LinkingDirection;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.BikeWalkableEdge;
import org.opentripplanner.routing.edgetype.CarPickupableEdge;
import org.opentripplanner.routing.edgetype.StreetEdgeCostExtension;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.edgetype.TemporaryPartialStreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.vertextype.BarrierVertex;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.opentripplanner.routing.vertextype.OsmVertex;
import org.opentripplanner.routing.vertextype.SplitterVertex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.util.BitSetUtils;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetEdge
extends Edge
implements BikeWalkableEdge,
Cloneable,
CarPickupableEdge {
    private static final Logger LOG = LoggerFactory.getLogger(StreetEdge.class);
    private StreetEdgeCostExtension costExtension;
    private static final long serialVersionUID = 1L;
    public static final int CLASS_STREET = 3;
    public static final int CLASS_CROSSING = 4;
    public static final int CLASS_OTHERPATH = 5;
    public static final int CLASS_OTHER_PLATFORM = 8;
    public static final int CLASS_TRAIN_PLATFORM = 16;
    public static final int CLASS_LINK = 32;
    private static final double GREENWAY_SAFETY_FACTOR = 0.1;
    public static final float DEFAULT_CAR_SPEED = 11.2f;
    private static final int BACK_FLAG_INDEX = 0;
    private static final int ROUNDABOUT_FLAG_INDEX = 1;
    private static final int HASBOGUSNAME_FLAG_INDEX = 2;
    private static final int MOTOR_VEHICLE_NOTHRUTRAFFIC = 3;
    private static final int STAIRS_FLAG_INDEX = 4;
    private static final int SLOPEOVERRIDE_FLAG_INDEX = 5;
    private static final int WHEELCHAIR_ACCESSIBLE_FLAG_INDEX = 6;
    private static final int BICYCLE_NOTHRUTRAFFIC = 7;
    private static final int WALK_NOTHRUTRAFFIC = 8;
    private short flags;
    private int length_mm;
    protected float bicycleSafetyFactor;
    private byte[] compactGeometry;
    private I18NString name;
    private StreetTraversalPermission permission;
    public long wayId;
    private int streetClass = 5;
    private float carSpeed;
    private byte inAngle;
    private byte outAngle;
    private List<TurnRestriction> turnRestrictions = List.of();

    public StreetEdge(StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name, double length, StreetTraversalPermission permission, boolean back) {
        super(v1, v2);
        this.setBack(back);
        this.setGeometry(geometry);
        this.length_mm = (int)(length * 1000.0);
        if (this.length_mm == 0) {
            LOG.warn("StreetEdge {} from {} to {} has length of 0. This is usually an error.", new Object[]{name, v1, v2});
        }
        this.bicycleSafetyFactor = 1.0f;
        this.name = name;
        this.setPermission(permission);
        this.setCarSpeed(11.2f);
        this.setWheelchairAccessible(true);
        if (geometry != null) {
            try {
                for (Coordinate c : geometry.getCoordinates()) {
                    if (Double.isNaN(c.x)) {
                        System.out.println("X DOOM");
                    }
                    if (!Double.isNaN(c.y)) continue;
                    System.out.println("Y DOOM");
                }
                double angleRadians = DirectionUtils.getLastAngle((Geometry)geometry);
                this.outAngle = (byte)Math.round(angleRadians * 128.0 / Math.PI + 128.0);
                angleRadians = DirectionUtils.getFirstAngle((Geometry)geometry);
                this.inAngle = (byte)Math.round(angleRadians * 128.0 / Math.PI + 128.0);
            }
            catch (IllegalArgumentException iae) {
                LOG.error("exception while determining street edge angles. setting to zero. there is probably something wrong with this street segment's geometry.");
                this.inAngle = 0;
                this.outAngle = 0;
            }
        }
    }

    public StreetEdge(StreetVertex v1, StreetVertex v2, LineString geometry, String name, double length, StreetTraversalPermission permission, boolean back) {
        this(v1, v2, geometry, new NonLocalizedString(name), length, permission, back);
    }

    public StreetEdge(StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name, StreetTraversalPermission permission, boolean back) {
        this(v1, v2, geometry, name, SphericalDistanceLibrary.length(geometry), permission, back);
    }

    public boolean canTraverse(TraverseModeSet modes) {
        return this.getPermission().allows(modes);
    }

    private boolean canTraverse(RoutingRequest options, TraverseMode mode) {
        if (mode.isWalking() && options.wheelchairAccessible) {
            if (!this.isWheelchairAccessible()) {
                return false;
            }
            if ((double)this.getMaxSlope() > options.maxWheelchairSlope) {
                return false;
            }
        }
        return this.canTraverseIncludingBarrier(mode);
    }

    public boolean canTraverseIncludingBarrier(TraverseMode mode) {
        StreetTraversalPermission permission = this.getPermission();
        if (this.fromv instanceof BarrierVertex) {
            permission = permission.intersection(((BarrierVertex)this.fromv).getBarrierPermissions());
        }
        if (this.tov instanceof BarrierVertex) {
            permission = permission.intersection(((BarrierVertex)this.tov).getBarrierPermissions());
        }
        return permission.allows(mode);
    }

    public PackedCoordinateSequence getElevationProfile() {
        return null;
    }

    public boolean isElevationFlattened() {
        return false;
    }

    public float getMaxSlope() {
        return 0.0f;
    }

    @Override
    public double getDistanceMeters() {
        return (double)this.length_mm / 1000.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public State traverse(State s0) {
        StateEditor dropOff;
        StateEditor inCar;
        State state;
        StateEditor editor;
        RoutingRequest options = s0.getOptions();
        if (s0.getNonTransitMode() == TraverseMode.BICYCLE) {
            if (this.canTraverse(options, TraverseMode.BICYCLE)) {
                editor = this.doTraverse(s0, options, TraverseMode.BICYCLE, false);
            } else {
                if (!this.canTraverse(options, TraverseMode.WALK)) return null;
                editor = this.doTraverse(s0, options, TraverseMode.WALK, true);
            }
        } else {
            editor = this.canTraverse(options, s0.getNonTransitMode()) ? this.doTraverse(s0, options, s0.getNonTransitMode(), false) : null;
        }
        State state2 = state = editor != null ? editor.makeState() : null;
        if (this.canPickupAndDrive(s0) && (inCar = this.doTraverse(s0, options, TraverseMode.CAR, false)) != null) {
            this.driveAfterPickup(s0, inCar);
            State forkState = inCar.makeState();
            if (forkState != null) {
                forkState.addToExistingResultChain(state);
                return forkState;
            }
        }
        if (!this.canDropOffAfterDriving(s0) || this.getPermission().allows(TraverseMode.CAR) || (dropOff = this.doTraverse(s0, options, TraverseMode.WALK, false)) == null) return state;
        this.dropOffAfterDriving(s0, dropOff);
        return dropOff.makeState();
    }

    private StateEditor doTraverse(State s0, RoutingRequest options, TraverseMode traverseMode, boolean walkingBike) {
        double weight;
        double time;
        if (traverseMode == null) {
            return null;
        }
        boolean backWalkingBike = s0.isBackWalkingBike();
        TraverseMode backMode = s0.getBackMode();
        Edge backEdge = s0.getBackEdge();
        if (backEdge != null && (this.isReverseOf(backEdge) || backEdge.isReverseOf(this))) {
            return null;
        }
        if (!this.canTraverse(options, traverseMode)) {
            return null;
        }
        double speed = this.calculateSpeed(options, traverseMode, walkingBike);
        block0 : switch (traverseMode) {
            case BICYCLE: {
                time = this.getEffectiveBikeDistance() / speed;
                switch (options.bicycleOptimizeType) {
                    case SAFE: {
                        weight = (double)this.bicycleSafetyFactor * this.getDistanceMeters() / speed;
                        break;
                    }
                    case GREENWAYS: {
                        weight = (double)this.bicycleSafetyFactor * this.getDistanceMeters() / speed;
                        if (!((double)this.bicycleSafetyFactor <= 0.1)) break block0;
                        weight *= 0.66;
                        break;
                    }
                    case FLAT: {
                        weight = this.getDistanceMeters() / speed + this.getEffectiveBikeWorkCost();
                        break;
                    }
                    case QUICK: {
                        weight = this.getEffectiveBikeDistance() / speed;
                        break;
                    }
                    case TRIANGLE: {
                        double quick = this.getEffectiveBikeDistance();
                        double safety = (double)this.bicycleSafetyFactor * this.getDistanceMeters();
                        double slope = this.getEffectiveBikeWorkCost();
                        weight = quick * options.bikeTriangleTimeFactor + slope * options.bikeTriangleSlopeFactor + safety * options.bikeTriangleSafetyFactor;
                        weight /= speed;
                        break;
                    }
                    default: {
                        weight = this.getDistanceMeters() / speed;
                        break;
                    }
                }
                break;
            }
            case WALK: {
                if (options.wheelchairAccessible) {
                    time = this.getEffectiveWalkDistance() / speed;
                    weight = this.getEffectiveBikeDistance() / speed;
                    break;
                }
                if (walkingBike) {
                    time = weight = this.getEffectiveBikeDistance() / speed;
                    break;
                }
                time = weight = this.getEffectiveWalkDistance() / speed;
                break;
            }
            default: {
                time = weight = this.getDistanceMeters() / speed;
            }
        }
        weight = this.isStairs() ? (weight *= options.stairsReluctance) : (weight *= options.getReluctance(traverseMode, walkingBike));
        StateEditor s1 = this.createEditor(s0, this, traverseMode, walkingBike);
        if (this.isTraversalBlockedByNoThruTraffic(traverseMode, backEdge, s0, s1)) {
            return null;
        }
        int roundedTime = (int)Math.ceil(time);
        if (backEdge instanceof StreetEdge) {
            double realTurnCost;
            IntersectionVertex traversedVertex;
            StreetEdge backPSE = (StreetEdge)backEdge;
            RoutingRequest backOptions = s0.getOptions();
            double backSpeed = backPSE.calculateSpeed(backOptions, backMode, backWalkingBike);
            if (options.arriveBy && !this.canTurnOnto(backPSE, s0, backMode)) {
                return null;
            }
            if (!options.arriveBy && !backPSE.canTurnOnto(this, s0, traverseMode)) {
                return null;
            }
            if (options.arriveBy && this.tov instanceof IntersectionVertex) {
                traversedVertex = (IntersectionVertex)this.tov;
                realTurnCost = backOptions.getIntersectionTraversalCostModel().computeTraversalCost(traversedVertex, this, backPSE, backMode, backOptions, (float)speed, (float)backSpeed);
            } else if (!options.arriveBy && this.fromv instanceof IntersectionVertex) {
                traversedVertex = (IntersectionVertex)this.fromv;
                realTurnCost = options.getIntersectionTraversalCostModel().computeTraversalCost(traversedVertex, backPSE, this, traverseMode, options, (float)backSpeed, (float)speed);
            } else {
                LOG.debug("Not computing turn cost for edge {}", (Object)this);
                realTurnCost = 0.0;
            }
            if (!traverseMode.isDriving()) {
                s1.incrementWalkDistance(realTurnCost / 100.0);
            }
            int turnTime = (int)Math.ceil(realTurnCost);
            roundedTime += turnTime;
            weight += options.turnReluctance * realTurnCost;
        }
        if (!traverseMode.isDriving()) {
            s1.incrementWalkDistance(this.getEffectiveBikeDistance());
        }
        if (this.costExtension != null) {
            weight += this.costExtension.calculateExtraCost(options, this.length_mm, traverseMode);
        }
        s1.incrementTimeInSeconds(roundedTime);
        s1.incrementWeight(weight);
        return s1;
    }

    private boolean isTraversalBlockedByNoThruTraffic(TraverseMode traverseMode, Edge backEdge, State s0, StateEditor s1) {
        if (this.isNoThruTraffic(traverseMode)) {
            if (backEdge instanceof StreetEdge && !((StreetEdge)backEdge).isNoThruTraffic(traverseMode)) {
                s1.setEnteredNoThroughTrafficArea();
            }
        } else if (s0.hasEnteredNoThruTrafficArea()) {
            return true;
        }
        return false;
    }

    public boolean isNoThruTraffic(TraverseMode traverseMode) {
        if (traverseMode.isCycling()) {
            return this.isBicycleNoThruTraffic();
        }
        if (traverseMode.isDriving()) {
            return this.isMotorVehicleNoThruTraffic();
        }
        if (traverseMode.isWalking()) {
            return this.isWalkNoThruTraffic();
        }
        return false;
    }

    private double calculateCarSpeed(RoutingRequest options) {
        return this.getCarSpeed();
    }

    public double calculateSpeed(RoutingRequest options, TraverseMode traverseMode, boolean walkingBike) {
        if (traverseMode == null) {
            return Double.NaN;
        }
        if (traverseMode.isDriving()) {
            return this.calculateCarSpeed(options);
        }
        double speed = options.getSpeed(traverseMode, walkingBike);
        return this.isStairs() ? speed / options.stairsTimeFactor : speed;
    }

    public double getEffectiveBikeDistance() {
        return this.getDistanceMeters();
    }

    public double getEffectiveBikeWorkCost() {
        return this.getDistanceMeters();
    }

    @Override
    public double getEffectiveWalkDistance() {
        return this.getDistanceMeters();
    }

    public void setBicycleSafetyFactor(float bicycleSafetyFactor) {
        this.bicycleSafetyFactor = bicycleSafetyFactor;
    }

    public float getBicycleSafetyFactor() {
        return this.bicycleSafetyFactor;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    @Override
    public String toString() {
        return "StreetEdge(" + this.name + ", " + this.fromv + " -> " + this.tov + " length=" + this.getDistanceMeters() + " carSpeed=" + this.getCarSpeed() + " permission=" + this.getPermission() + ")";
    }

    public StreetEdge clone() {
        try {
            return (StreetEdge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canTurnOnto(Edge e, State state, TraverseMode mode) {
        for (TurnRestriction turnRestriction : this.turnRestrictions) {
            if (!(turnRestriction.type == TurnRestrictionType.ONLY_TURN ? !e.isEquivalentTo(turnRestriction.to) && turnRestriction.modes.contains(mode) && turnRestriction.active(state.getTimeSeconds()) : e.isEquivalentTo(turnRestriction.to) && turnRestriction.modes.contains(mode) && turnRestriction.active(state.getTimeSeconds()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    public void setName(I18NString name) {
        this.name = name;
    }

    @Override
    public LineString getGeometry() {
        return CompactLineString.uncompactLineString(this.fromv.getLon(), this.fromv.getLat(), this.tov.getLon(), this.tov.getLat(), this.compactGeometry, this.isBack());
    }

    private void setGeometry(LineString geometry) {
        this.compactGeometry = CompactLineString.compactLineString(this.fromv.getLon(), this.fromv.getLat(), this.tov.getLon(), this.tov.getLat(), this.isBack() ? geometry.reverse() : geometry, this.isBack());
    }

    public void shareData(StreetEdge reversedEdge) {
        if (Arrays.equals(this.compactGeometry, reversedEdge.compactGeometry)) {
            this.compactGeometry = reversedEdge.compactGeometry;
        } else {
            LOG.warn("Can't share geometry between {} and {}", (Object)this, (Object)reversedEdge);
        }
    }

    public boolean isWheelchairAccessible() {
        return BitSetUtils.get(this.flags, 6);
    }

    public void setWheelchairAccessible(boolean wheelchairAccessible) {
        this.flags = BitSetUtils.set(this.flags, 6, wheelchairAccessible);
    }

    public StreetTraversalPermission getPermission() {
        return this.permission;
    }

    public void setPermission(StreetTraversalPermission permission) {
        this.permission = permission;
    }

    public int getStreetClass() {
        return this.streetClass;
    }

    public void setStreetClass(int streetClass) {
        this.streetClass = streetClass;
    }

    public boolean isBack() {
        return BitSetUtils.get(this.flags, 0);
    }

    public void setBack(boolean back) {
        this.flags = BitSetUtils.set(this.flags, 0, back);
    }

    @Override
    public boolean isRoundabout() {
        return BitSetUtils.get(this.flags, 1);
    }

    public void setRoundabout(boolean roundabout) {
        this.flags = BitSetUtils.set(this.flags, 1, roundabout);
    }

    @Override
    public boolean hasBogusName() {
        return BitSetUtils.get(this.flags, 2);
    }

    public void setHasBogusName(boolean hasBogusName) {
        this.flags = BitSetUtils.set(this.flags, 2, hasBogusName);
    }

    public boolean isWalkNoThruTraffic() {
        return BitSetUtils.get(this.flags, 8);
    }

    public void setWalkNoThruTraffic(boolean noThruTraffic) {
        this.flags = BitSetUtils.set(this.flags, 8, noThruTraffic);
    }

    public boolean isMotorVehicleNoThruTraffic() {
        return BitSetUtils.get(this.flags, 3);
    }

    public void setMotorVehicleNoThruTraffic(boolean noThruTraffic) {
        this.flags = BitSetUtils.set(this.flags, 3, noThruTraffic);
    }

    public boolean isBicycleNoThruTraffic() {
        return BitSetUtils.get(this.flags, 7);
    }

    public void setBicycleNoThruTraffic(boolean noThruTraffic) {
        this.flags = BitSetUtils.set(this.flags, 7, noThruTraffic);
    }

    public boolean isStairs() {
        return BitSetUtils.get(this.flags, 4);
    }

    public void setStairs(boolean stairs) {
        this.flags = BitSetUtils.set(this.flags, 4, stairs);
    }

    public float getCarSpeed() {
        return this.carSpeed;
    }

    public void setCarSpeed(float carSpeed) {
        this.carSpeed = carSpeed;
    }

    public boolean isSlopeOverride() {
        return BitSetUtils.get(this.flags, 5);
    }

    public void setSlopeOverride(boolean slopeOverride) {
        this.flags = BitSetUtils.set(this.flags, 5, slopeOverride);
    }

    public int getInAngle() {
        return (int)Math.round((double)(this.inAngle * 180) / 128.0);
    }

    public int getOutAngle() {
        return (int)Math.round((double)(this.outAngle * 180) / 128.0);
    }

    public void setCostExtension(StreetEdgeCostExtension costExtension) {
        this.costExtension = costExtension;
    }

    public P2<StreetEdge> splitDestructively(SplitterVertex v) {
        double frac;
        P2<LineString> geoms = GeometryUtils.splitGeometryAtPoint((Geometry)this.getGeometry(), v.getCoordinate());
        StreetEdge e1 = new StreetEdge((StreetVertex)this.fromv, v, (LineString)geoms.first, this.name, this.permission, this.isBack());
        StreetEdge e2 = new StreetEdge(v, (StreetVertex)this.tov, (LineString)geoms.second, this.name, this.permission, this.isBack());
        e1.wayId = this.wayId;
        e2.wayId = this.wayId;
        if (!this.isBack()) {
            frac = (double)e1.length_mm / (double)(e1.length_mm + e2.length_mm);
            e1.length_mm = (int)((double)this.length_mm * frac);
            e2.length_mm = this.length_mm - e1.length_mm;
        } else {
            frac = (double)e2.length_mm / (double)(e1.length_mm + e2.length_mm);
            e2.length_mm = (int)((double)this.length_mm * frac);
            e1.length_mm = this.length_mm - e2.length_mm;
        }
        if (e1.length_mm <= 0) {
            LOG.error("Edge 1 ({}) split at vertex at {},{} has length {} mm. Setting to 1 mm.", new Object[]{e1.wayId, v.getLat(), v.getLon(), e1.length_mm});
            e1.length_mm = 1;
        }
        if (e2.length_mm <= 0) {
            LOG.error("Edge 2 ({}) split at vertex at {},{}  has length {} mm. Setting to 1 mm.", new Object[]{e2.wayId, v.getLat(), v.getLon(), e2.length_mm});
            e2.length_mm = 1;
        }
        if (e1.length_mm < 0 || e2.length_mm < 0) {
            e1.tov.removeIncoming(e1);
            e1.fromv.removeOutgoing(e1);
            e2.tov.removeIncoming(e2);
            e2.fromv.removeOutgoing(e2);
            throw new IllegalStateException("Split street is longer than original street!");
        }
        for (StreetEdge e : new StreetEdge[]{e1, e2}) {
            e.setBicycleSafetyFactor(this.getBicycleSafetyFactor());
            e.setHasBogusName(this.hasBogusName());
            e.setStairs(this.isStairs());
            e.setWheelchairAccessible(this.isWheelchairAccessible());
            e.setBack(this.isBack());
        }
        P2<StreetEdge> splitEdges = new P2<StreetEdge>(e1, e2);
        StreetEdge.copyRestrictionsToSplitEdges(this, splitEdges);
        return splitEdges;
    }

    public P2<StreetEdge> splitNonDestructively(SplitterVertex v, DisposableEdgeCollection tempEdges, LinkingDirection direction) {
        P2<LineString> geoms = GeometryUtils.splitGeometryAtPoint((Geometry)this.getGeometry(), v.getCoordinate());
        TemporaryPartialStreetEdge e1 = null;
        TemporaryPartialStreetEdge e2 = null;
        if (direction == LinkingDirection.OUTGOING || direction == LinkingDirection.BOTH_WAYS) {
            e1 = new TemporaryPartialStreetEdge(this, (StreetVertex)this.fromv, v, (LineString)geoms.first, this.name);
            e1.setMotorVehicleNoThruTraffic(this.isMotorVehicleNoThruTraffic());
            e1.setBicycleNoThruTraffic(this.isBicycleNoThruTraffic());
            e1.setWalkNoThruTraffic(this.isWalkNoThruTraffic());
            e1.setStreetClass(this.getStreetClass());
            e1.setStairs(this.isStairs());
            tempEdges.addEdge(e1);
        }
        if (direction == LinkingDirection.INCOMING || direction == LinkingDirection.BOTH_WAYS) {
            e2 = new TemporaryPartialStreetEdge(this, v, (StreetVertex)this.tov, (LineString)geoms.second, this.name);
            e2.setMotorVehicleNoThruTraffic(this.isMotorVehicleNoThruTraffic());
            e2.setBicycleNoThruTraffic(this.isBicycleNoThruTraffic());
            e2.setWalkNoThruTraffic(this.isWalkNoThruTraffic());
            e2.setStreetClass(this.getStreetClass());
            e2.setStairs(this.isStairs());
            tempEdges.addEdge(e2);
        }
        P2<Object> splitEdges = new P2<Object>(e1, e2);
        StreetEdge.copyRestrictionsToSplitEdges(this, splitEdges);
        return splitEdges;
    }

    private static void copyRestrictionsToSplitEdges(StreetEdge edge, P2<StreetEdge> splitEdges) {
        edge.getTurnRestrictions().forEach(restriction -> {
            StreetEdge fromEdge = StreetEdge.shouldUseFirstSplitEdge(edge, restriction) ? (StreetEdge)splitEdges.first : (StreetEdge)splitEdges.second;
            TurnRestriction splitTurnRestriction = new TurnRestriction(fromEdge, restriction.to, restriction.type, restriction.modes, restriction.time);
            LOG.debug("Recreate new restriction {} with split edge as from edge {}", (Object)splitTurnRestriction, (Object)fromEdge);
            fromEdge.addTurnRestriction(splitTurnRestriction);
            edge.removeTurnRestriction((TurnRestriction)restriction);
        });
        StreetEdge.applyToAdjacentEdges(edge, (StreetEdge)splitEdges.second, edge.getToVertex().getOutgoing());
        StreetEdge.applyToAdjacentEdges(edge, (StreetEdge)splitEdges.first, edge.getFromVertex().getIncoming());
    }

    private static boolean shouldUseFirstSplitEdge(StreetEdge edge, TurnRestriction restriction) {
        return restriction.to.getToVertex() == edge.getToVertex();
    }

    private static void applyToAdjacentEdges(StreetEdge formerEdge, StreetEdge newToEdge, Collection<Edge> adjacentEdges) {
        adjacentEdges.stream().filter(StreetEdge.class::isInstance).map(StreetEdge.class::cast).flatMap(originatingEdge -> originatingEdge.getTurnRestrictions().stream()).filter(restriction -> restriction.to == formerEdge).forEach(restriction -> StreetEdge.applyRestrictionsToNewEdge(newToEdge, restriction));
    }

    private static void applyRestrictionsToNewEdge(StreetEdge newEdge, TurnRestriction restriction) {
        TurnRestriction splitTurnRestriction = new TurnRestriction(restriction.from, newEdge, restriction.type, restriction.modes, restriction.time);
        LOG.debug("Recreate new restriction {} with split edge as to edge {}", (Object)splitTurnRestriction, (Object)newEdge);
        restriction.from.addTurnRestriction(splitTurnRestriction);
        restriction.from.removeTurnRestriction(restriction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTurnRestriction(TurnRestriction turnRestriction) {
        if (turnRestriction == null) {
            return;
        }
        StreetEdge streetEdge = this;
        synchronized (streetEdge) {
            HashSet<TurnRestriction> temp = new HashSet<TurnRestriction>(this.turnRestrictions);
            temp.add(turnRestriction);
            this.turnRestrictions = List.copyOf(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTurnRestriction(TurnRestriction turnRestriction) {
        if (turnRestriction == null) {
            return;
        }
        StreetEdge streetEdge = this;
        synchronized (streetEdge) {
            if (this.turnRestrictions.contains(turnRestriction)) {
                if (this.turnRestrictions.size() == 1) {
                    this.turnRestrictions = List.of();
                } else {
                    HashSet<TurnRestriction> withRemoved = new HashSet<TurnRestriction>(this.turnRestrictions);
                    withRemoved.remove(turnRestriction);
                    this.turnRestrictions = List.copyOf(withRemoved);
                }
            }
        }
    }

    @Nonnull
    public Collection<TurnRestriction> getTurnRestrictions() {
        return this.turnRestrictions;
    }

    public long getStartOsmNodeId() {
        if (this.fromv instanceof OsmVertex) {
            return ((OsmVertex)this.fromv).nodeId;
        }
        if (this.fromv instanceof SplitterVertex) {
            return ((SplitterVertex)this.fromv).previousNodeId;
        }
        return -1L;
    }

    public long getEndOsmNodeId() {
        if (this.tov instanceof OsmVertex) {
            return ((OsmVertex)this.tov).nodeId;
        }
        if (this.tov instanceof SplitterVertex) {
            return ((SplitterVertex)this.tov).nextNodeId;
        }
        return -1L;
    }
}

