/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.BikeWalkableEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;

public class PathwayEdge
extends Edge
implements BikeWalkableEdge {
    private static final long serialVersionUID = -3311099256178798982L;
    public static final I18NString DEFAULT_NAME = new NonLocalizedString("pathway");
    private final I18NString name;
    private final int traversalTime;
    private final double distance;
    private final int steps;
    private final double slope;
    private final boolean wheelchairAccessible;
    private final FeedScopedId id;

    public static PathwayEdge lowCost(Vertex fromV, Vertex toV, I18NString name) {
        return PathwayEdge.lowCost(fromV, toV, null, name, true);
    }

    public static PathwayEdge lowCost(Vertex fromV, Vertex toV, FeedScopedId id, I18NString name, boolean wheelchairAccessible) {
        return new PathwayEdge(fromV, toV, id, name, 0, 0.0, 0, 0.0, wheelchairAccessible);
    }

    public PathwayEdge(Vertex fromv, Vertex tov, FeedScopedId id, I18NString name, int traversalTime, double distance, int steps, double slope, boolean wheelchairAccessible) {
        super(fromv, tov);
        this.name = Objects.requireNonNullElse(name, DEFAULT_NAME);
        this.id = id;
        this.traversalTime = traversalTime;
        this.steps = steps;
        this.slope = slope;
        this.wheelchairAccessible = wheelchairAccessible;
        this.distance = distance;
    }

    @Override
    public String getDirection() {
        return null;
    }

    @Override
    public double getDistanceMeters() {
        return this.distance;
    }

    @Override
    public double getEffectiveWalkDistance() {
        if (this.traversalTime > 0) {
            return 0.0;
        }
        return this.distance;
    }

    @Override
    public int getDistanceIndependentTime() {
        return this.traversalTime;
    }

    @Override
    public LineString getGeometry() {
        Coordinate[] coordinates = new Coordinate[]{this.getFromVertex().getCoordinate(), this.getToVertex().getCoordinate()};
        return GeometryUtils.getGeometryFactory().createLineString(coordinates);
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    public FeedScopedId getId() {
        return this.id;
    }

    @Override
    public State traverse(State s0) {
        StateEditor s1 = this.createEditorForWalking(s0, this);
        if (s1 == null) {
            return null;
        }
        int time = this.traversalTime;
        if (s0.getOptions().wheelchairAccessible) {
            if (!this.wheelchairAccessible) {
                return null;
            }
            if (this.slope > s0.getOptions().maxWheelchairSlope) {
                return null;
            }
        }
        if (time == 0) {
            if (this.distance > 0.0) {
                time = (int)(this.distance * s0.getOptions().walkSpeed);
            } else if (this.steps > 0) {
                time = (int)(0.4 * (double)Math.abs(this.steps) * s0.getOptions().walkSpeed);
            }
        }
        if (time > 0) {
            double weight = (double)time * s0.getOptions().getReluctance(TraverseMode.WALK, s0.getNonTransitMode() == TraverseMode.BICYCLE);
            s1.incrementTimeInSeconds(time);
            s1.incrementWeight(weight);
        } else {
            s1.incrementWeight(1.0);
        }
        return s1.makeState();
    }
}

