/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.ElevatorEdge;
import org.opentripplanner.routing.edgetype.StreetTraversalPermission;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.util.I18NString;

public class ElevatorHopEdge
extends Edge
implements ElevatorEdge {
    private static final long serialVersionUID = 3925814840369402222L;
    private StreetTraversalPermission permission;
    public boolean wheelchairAccessible = true;
    private double levels = 1.0;
    private int travelTime = 0;

    public ElevatorHopEdge(Vertex from, Vertex to, StreetTraversalPermission permission, double levels, int travelTime) {
        this(from, to, permission);
        this.levels = levels;
        this.travelTime = travelTime;
    }

    public ElevatorHopEdge(Vertex from, Vertex to, StreetTraversalPermission permission) {
        super(from, to);
        this.permission = permission;
    }

    @Override
    public State traverse(State s0) {
        RoutingRequest options = s0.getOptions();
        if (options.wheelchairAccessible && !this.wheelchairAccessible) {
            return null;
        }
        TraverseMode mode = s0.getNonTransitMode();
        if (mode == TraverseMode.WALK && !this.permission.allows(StreetTraversalPermission.PEDESTRIAN)) {
            return null;
        }
        if (mode == TraverseMode.BICYCLE && !this.permission.allows(StreetTraversalPermission.BICYCLE)) {
            return null;
        }
        if (mode == TraverseMode.CAR && !this.permission.allows(StreetTraversalPermission.CAR)) {
            return null;
        }
        StateEditor s1 = this.createEditorForDrivingOrWalking(s0, this);
        s1.incrementWeight(this.travelTime > 0 ? (double)this.travelTime : (double)options.elevatorHopCost * this.levels);
        s1.incrementTimeInSeconds(this.travelTime > 0 ? this.travelTime : (int)((double)options.elevatorHopTime * this.levels));
        return s1.makeState();
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public I18NString getName() {
        return null;
    }

    public StreetTraversalPermission getPermission() {
        return this.permission;
    }

    @Override
    public String toString() {
        return "ElevatorHopEdge(" + this.fromv + " -> " + this.tov + ")";
    }
}

