/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.edgetype.BikeWalkableEdge;
import org.opentripplanner.routing.edgetype.ElevatorEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.vertextype.ElevatorOffboardVertex;
import org.opentripplanner.routing.vertextype.ElevatorOnboardVertex;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;

public class ElevatorBoardEdge
extends Edge
implements BikeWalkableEdge,
ElevatorEdge {
    private static final long serialVersionUID = 3925814840369402222L;
    private LineString the_geom;

    public ElevatorBoardEdge(ElevatorOffboardVertex from, ElevatorOnboardVertex to) {
        super(from, to);
        Coordinate[] coords = new Coordinate[]{new Coordinate(from.getX(), from.getY()), new Coordinate(to.getX(), to.getY())};
        this.the_geom = GeometryUtils.getGeometryFactory().createLineString(coords);
    }

    @Override
    public State traverse(State s0) {
        StateEditor s1 = this.createEditorForDrivingOrWalking(s0, this);
        if (s1 == null) {
            return null;
        }
        RoutingRequest options = s0.getOptions();
        s1.incrementWeight(options.elevatorBoardCost);
        s1.incrementTimeInSeconds(options.elevatorBoardTime);
        return s1.makeState();
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    @Override
    public LineString getGeometry() {
        return this.the_geom;
    }

    @Override
    public I18NString getName() {
        return new NonLocalizedString("Elevator");
    }

    @Override
    public boolean hasBogusName() {
        return true;
    }

    @Override
    public String toString() {
        return "ElevatorBoardEdge(" + this.fromv + " -> " + this.tov + ")";
    }
}

