/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.edgetype;

import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Edge;

public interface BikeWalkableEdge {
    default public boolean canSwitchToWalkingBike(State state) {
        return state.getNonTransitMode() == TraverseMode.BICYCLE;
    }

    default public void switchToWalkingBike(RoutingRequest options, StateEditor editor) {
        State parentState = editor.getBackState();
        boolean shouldIncludeCost = !parentState.isBackWalkingBike() && this.hadBackModeSet(parentState);
        editor.setBackWalkingBike(true);
        if (shouldIncludeCost) {
            editor.incrementWeight(options.bikeSwitchCost);
            editor.incrementTimeInSeconds(options.bikeSwitchTime);
        }
    }

    default public void switchToBiking(RoutingRequest options, StateEditor editor) {
        State parentState = editor.getBackState();
        boolean shouldIncludeCost = parentState.isBackWalkingBike();
        editor.setBackWalkingBike(false);
        if (shouldIncludeCost) {
            editor.incrementWeight(options.bikeSwitchCost);
            editor.incrementTimeInSeconds(options.bikeSwitchTime);
        }
    }

    default public boolean hadBackModeSet(State state) {
        do {
            if (state.getBackMode() == null) continue;
            return state.getBackMode().isOnStreetNonTransit();
        } while ((state = state.getBackState()) != null);
        return false;
    }

    default public StateEditor createEditorForDrivingOrWalking(State s0, Edge edge) {
        if (s0.getNonTransitMode() == TraverseMode.CAR) {
            return s0.edit(edge);
        }
        return this.createEditor(s0, edge, TraverseMode.WALK, s0.getNonTransitMode() == TraverseMode.BICYCLE);
    }

    default public StateEditor createEditorForWalking(State s0, Edge edge) {
        if (s0.getNonTransitMode() == TraverseMode.CAR) {
            return null;
        }
        return this.createEditor(s0, edge, TraverseMode.WALK, s0.getNonTransitMode() == TraverseMode.BICYCLE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public StateEditor createEditor(State s0, Edge edge, TraverseMode mode, boolean bicycleWalking) {
        StateEditor editor = s0.edit(edge);
        if (bicycleWalking) {
            if (!this.canSwitchToWalkingBike(s0)) return null;
            this.switchToWalkingBike(s0.getOptions(), editor);
        } else if (mode == TraverseMode.BICYCLE) {
            this.switchToBiking(s0.getOptions(), editor);
        }
        editor.setBackMode(mode);
        return editor;
    }
}

