/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core.intersection_model;

import java.io.Serializable;
import org.opentripplanner.graph_builder.module.osm.WayPropertySetSource;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.intersection_model.AbstractIntersectionTraversalCostModel;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIntersectionTraversalCostModel
extends AbstractIntersectionTraversalCostModel
implements Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(SimpleIntersectionTraversalCostModel.class);
    private final WayPropertySetSource.DrivingDirection drivingDirection;
    private final double acrossTrafficBicyleTurnMultiplier = this.getSafeBicycleTurnModifier() * 3.0;

    public SimpleIntersectionTraversalCostModel(WayPropertySetSource.DrivingDirection drivingDirection) {
        this.drivingDirection = drivingDirection;
    }

    @Override
    public double computeTraversalCost(IntersectionVertex v, StreetEdge from, StreetEdge to, TraverseMode mode, RoutingRequest request, float fromSpeed, float toSpeed) {
        if (v.inferredFreeFlowing()) {
            return 0.0;
        }
        if (mode.isDriving()) {
            return this.computeDrivingTraversalCost(v, from, to, request);
        }
        if (mode.isCycling()) {
            double c = this.computeCyclingTraversalCost(v, from, to, fromSpeed, toSpeed, request);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Turning from {} to {} has a cost of {}", new Object[]{from, to, c});
            }
            return c;
        }
        return this.computeNonDrivingTraversalCost(v, from, to, fromSpeed, toSpeed);
    }

    protected boolean isSafeTurn(int turnAngle) {
        switch (this.drivingDirection) {
            case RIGHT_HAND_TRAFFIC: {
                return this.isRightTurn(turnAngle);
            }
            case LEFT_HAND_TRAFFIC: {
                return this.isLeftTurn(turnAngle);
            }
        }
        throw new RuntimeException("New driving direction introduced!");
    }

    protected boolean isTurnAcrossTraffic(int turnAngle) {
        switch (this.drivingDirection) {
            case RIGHT_HAND_TRAFFIC: {
                return this.isLeftTurn(turnAngle);
            }
            case LEFT_HAND_TRAFFIC: {
                return this.isRightTurn(turnAngle);
            }
        }
        throw new RuntimeException("New driving direction introduced!");
    }

    private double computeDrivingTraversalCost(IntersectionVertex v, StreetEdge from, StreetEdge to, RoutingRequest request) {
        double turnCost = 0.0;
        int turnAngle = this.calculateTurnAngle(from, to, request);
        if (v.trafficLight) {
            turnCost = this.isSafeTurn(turnAngle) ? this.getExpectedRightAtLightTimeSec() : (this.isTurnAcrossTraffic(turnAngle) ? this.getExpectedLeftAtLightTimeSec() : this.getExpectedStraightAtLightTimeSec());
        } else {
            if (from.getCarSpeed() > 25.0f && to.getCarSpeed() > 25.0f) {
                return 0.0;
            }
            turnCost = this.isSafeTurn(turnAngle) ? this.getExpectedRightNoLightTimeSec() : (this.isTurnAcrossTraffic(turnAngle) ? this.getExpectedLeftNoLightTimeSec() : this.getExpectedStraightNoLightTimeSec());
        }
        return turnCost;
    }

    private double computeCyclingTraversalCost(IntersectionVertex v, StreetEdge from, StreetEdge to, float fromSpeed, float toSpeed, RoutingRequest request) {
        int turnAngle = this.calculateTurnAngle(from, to, request);
        double baseCost = this.computeNonDrivingTraversalCost(v, from, to, fromSpeed, toSpeed);
        if (this.isTurnAcrossTraffic(turnAngle)) {
            return baseCost * this.getAcrossTrafficBicyleTurnMultiplier();
        }
        if (this.isSafeTurn(turnAngle)) {
            return baseCost * this.getSafeBicycleTurnModifier();
        }
        return baseCost;
    }

    private boolean isLeftTurn(int turnAngle) {
        return turnAngle >= this.getMinLeftTurnAngle() && turnAngle < this.getMaxLeftTurnAngle();
    }

    private boolean isRightTurn(int turnAngle) {
        return turnAngle >= this.getMinRightTurnAngle() && turnAngle < this.getMaxRightTurnAngle();
    }

    public int getMinRightTurnAngle() {
        return 45;
    }

    public int getMaxRightTurnAngle() {
        return 135;
    }

    public int getMinLeftTurnAngle() {
        return 225;
    }

    public int getMaxLeftTurnAngle() {
        return 315;
    }

    public double getExpectedRightAtLightTimeSec() {
        return 15.0;
    }

    public double getExpectedStraightAtLightTimeSec() {
        return 15.0;
    }

    public double getExpectedLeftAtLightTimeSec() {
        return 15.0;
    }

    public double getExpectedRightNoLightTimeSec() {
        return 8.0;
    }

    public double getExpectedStraightNoLightTimeSec() {
        return 5.0;
    }

    public double getExpectedLeftNoLightTimeSec() {
        return 8.0;
    }

    public double getSafeBicycleTurnModifier() {
        return 5.0;
    }

    public double getAcrossTrafficBicyleTurnMultiplier() {
        return this.acrossTrafficBicyleTurnMultiplier;
    }
}

