/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core.intersection_model;

import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalCostModel;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.vertextype.IntersectionVertex;

public abstract class AbstractIntersectionTraversalCostModel
implements IntersectionTraversalCostModel {
    protected double nonDrivingTurnCostFactor = 0.05;

    protected double computeNonDrivingTraversalCost(IntersectionVertex v, StreetEdge from, StreetEdge to, float fromSpeed, float toSpeed) {
        int inAngle;
        int outAngle = to.getOutAngle();
        int turnCost = Math.abs(outAngle - (inAngle = from.getInAngle()));
        if (turnCost > 180) {
            turnCost = 360 - turnCost;
        }
        return this.nonDrivingTurnCostFactor * (double)turnCost / (double)toSpeed;
    }

    protected int calculateTurnAngle(StreetEdge from, StreetEdge to, RoutingRequest options) {
        int angleIntoIntersection;
        int angleOutOfIntersection = to.getInAngle();
        if (angleOutOfIntersection < (angleIntoIntersection = from.getOutAngle())) {
            angleOutOfIntersection += 360;
        }
        return angleOutOfIntersection - angleIntoIntersection;
    }

    @Override
    public abstract double computeTraversalCost(IntersectionVertex var1, StreetEdge var2, StreetEdge var3, TraverseMode var4, RoutingRequest var5, float var6, float var7);
}

