/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.routing.core.TraverseMode;

public class TraverseModeSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1640048158419762255L;
    private static final int MODE_BICYCLE = 1;
    private static final int MODE_WALK = 2;
    private static final int MODE_CAR = 4;
    private static final int MODE_BUS = 16;
    private static final int MODE_TRAM = 32;
    private static final int MODE_SUBWAY = 64;
    private static final int MODE_RAIL = 128;
    private static final int MODE_FERRY = 256;
    private static final int MODE_CABLE_CAR = 512;
    private static final int MODE_GONDOLA = 1024;
    private static final int MODE_FUNICULAR = 2048;
    private static final int MODE_AIRPLANE = 4096;
    private static final int MODE_TROLLEYBUS = 8192;
    private static final int MODE_MONORAIL = 16384;
    private static final int MODE_TRANSIT = 32752;
    private static final int MODE_ALL = 32755;
    private int modes = 0;

    public TraverseModeSet(TraverseMode ... modes) {
        for (TraverseMode mode : modes) {
            this.modes |= this.getMaskForMode(mode);
        }
    }

    public static TraverseModeSet allModes() {
        TraverseModeSet modes = new TraverseModeSet(new TraverseMode[0]);
        modes.modes = 32755;
        return modes;
    }

    private final int getMaskForMode(TraverseMode mode) {
        switch (mode) {
            case BICYCLE: {
                return 1;
            }
            case WALK: {
                return 2;
            }
            case CAR: {
                return 4;
            }
            case BUS: {
                return 16;
            }
            case TRAM: {
                return 32;
            }
            case CABLE_CAR: {
                return 512;
            }
            case GONDOLA: {
                return 1024;
            }
            case FERRY: {
                return 256;
            }
            case FUNICULAR: {
                return 2048;
            }
            case SUBWAY: {
                return 64;
            }
            case RAIL: {
                return 128;
            }
            case TROLLEYBUS: {
                return 8192;
            }
            case MONORAIL: {
                return 16384;
            }
            case AIRPLANE: {
                return 4096;
            }
            case TRANSIT: {
                return 32752;
            }
        }
        return 0;
    }

    public TraverseModeSet(Collection<TraverseMode> modeList) {
        this(modeList.toArray(new TraverseMode[0]));
    }

    public void setMode(TraverseMode mode, boolean value) {
        int mask = this.getMaskForMode(mode);
        this.modes = value ? (this.modes |= mask) : (this.modes &= ~mask);
    }

    public boolean getBicycle() {
        return (this.modes & 1) != 0;
    }

    public boolean getWalk() {
        return (this.modes & 2) != 0;
    }

    public boolean getCar() {
        return (this.modes & 4) != 0;
    }

    public boolean getTram() {
        return (this.modes & 0x20) != 0;
    }

    public boolean getBus() {
        return (this.modes & 0x10) != 0;
    }

    public boolean getGondola() {
        return (this.modes & 0x400) != 0;
    }

    public boolean getFerry() {
        return (this.modes & 0x100) != 0;
    }

    public boolean getCableCar() {
        return (this.modes & 0x200) != 0;
    }

    public boolean getFunicular() {
        return (this.modes & 0x800) != 0;
    }

    public boolean getRail() {
        return (this.modes & 0x80) != 0;
    }

    public boolean getTrolleyBus() {
        return (this.modes & 0x2000) != 0;
    }

    public boolean geMonorail() {
        return (this.modes & 0x4000) != 0;
    }

    public boolean getSubway() {
        return (this.modes & 0x40) != 0;
    }

    public boolean getAirplane() {
        return (this.modes & 0x1000) != 0;
    }

    public void setBicycle(boolean bicycle) {
        this.modes = bicycle ? (this.modes |= 1) : (this.modes &= 0xFFFFFFFE);
    }

    public void setWalk(boolean walk) {
        this.modes = walk ? (this.modes |= 2) : (this.modes &= 0xFFFFFFFD);
    }

    public void setCar(boolean car) {
        this.modes = car ? (this.modes |= 4) : (this.modes &= 0xFFFFFFFB);
    }

    public void setTram(boolean tram) {
        this.modes = tram ? (this.modes |= 0x20) : (this.modes &= 0xFFFFFFDF);
    }

    public void setBus(boolean bus) {
        this.modes = bus ? (this.modes |= 0x10) : (this.modes &= 0xFFFFFFEF);
    }

    public void setFerry(boolean ferry) {
        this.modes = ferry ? (this.modes |= 0x100) : (this.modes &= 0xFFFFFEFF);
    }

    public void setCableCar(boolean cableCar) {
        this.modes = cableCar ? (this.modes |= 0x200) : (this.modes &= 0xFFFFFDFF);
    }

    public void setGondola(boolean gondola) {
        this.modes = gondola ? (this.modes |= 0x400) : (this.modes &= 0xFFFFFBFF);
    }

    public void setFunicular(boolean funicular) {
        this.modes = funicular ? (this.modes |= 0x800) : (this.modes &= 0xFFFFF7FF);
    }

    public void setSubway(boolean subway) {
        this.modes = subway ? (this.modes |= 0x40) : (this.modes &= 0xFFFFFFBF);
    }

    public void setRail(boolean rail) {
        this.modes = rail ? (this.modes |= 0x80) : (this.modes &= 0xFFFFFF7F);
    }

    public void setAirplane(boolean airplane) {
        this.modes = airplane ? (this.modes |= 0x1000) : (this.modes &= 0xFFFFEFFF);
    }

    public void setTrolleybus(boolean trolleybus) {
        this.modes = trolleybus ? (this.modes |= 0x2000) : (this.modes &= 0xFFFFDFFF);
    }

    public void setMonorail(boolean monorail) {
        this.modes = monorail ? (this.modes |= 0x4000) : (this.modes &= 0xFFFFBFFF);
    }

    public boolean isTransit() {
        return (this.modes & 0x7FF0) != 0;
    }

    public void setTransit(boolean transit) {
        this.modes = transit ? (this.modes |= 0x7FF0) : (this.modes &= 0xFFFF800F);
    }

    public TraverseModeSet getNonTransitSet() {
        TraverseModeSet retval = new TraverseModeSet(new TraverseMode[0]);
        retval.modes = this.modes;
        retval.setTransit(false);
        return retval;
    }

    public List<TraverseMode> getModes() {
        ArrayList<TraverseMode> modeList = new ArrayList<TraverseMode>();
        for (TraverseMode mode : TraverseMode.values()) {
            if ((this.modes & this.getMaskForMode(mode)) == 0) continue;
            modeList.add(mode);
        }
        return modeList;
    }

    public boolean isValid() {
        return this.modes != 0;
    }

    public boolean contains(TraverseMode mode) {
        return (this.modes & this.getMaskForMode(mode)) != 0;
    }

    public boolean get(int modeMask) {
        return (this.modes & modeMask) != 0;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (TraverseMode mode : TraverseMode.values()) {
            int mask = this.getMaskForMode(mode);
            if (mask == 0 || (this.modes & mask) != mask) continue;
            if (out.length() != 0) {
                out.append(", ");
            }
            out.append((Object)mode);
        }
        return "TraverseMode (" + out + ")";
    }

    public String getAsStr() {
        Object retVal = null;
        for (TraverseMode m : this.getModes()) {
            retVal = retVal == null ? "" : (String)retVal + ",";
            retVal = (String)retVal + m;
        }
        return retVal;
    }

    public TraverseModeSet clone() {
        try {
            return (TraverseModeSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.modes = 0;
    }

    public int hashCode() {
        return this.modes;
    }

    public boolean equals(Object other) {
        if (other instanceof TraverseModeSet) {
            return this.modes == ((TraverseModeSet)other).modes;
        }
        return false;
    }
}

