/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.util.EnumSet;
import org.opentripplanner.model.TransitMode;

public enum TraverseMode {
    WALK,
    BICYCLE,
    SCOOTER,
    CAR,
    TRAM,
    SUBWAY,
    RAIL,
    BUS,
    FERRY,
    CABLE_CAR,
    GONDOLA,
    FUNICULAR,
    TRANSIT,
    AIRPLANE,
    TROLLEYBUS,
    MONORAIL;

    private static final EnumSet<TraverseMode> TRANSIT_MODES;
    private static final EnumSet<TraverseMode> STREET_MODES;

    public boolean isTransit() {
        return TRANSIT_MODES.contains((Object)this);
    }

    public boolean isOnStreetNonTransit() {
        return STREET_MODES.contains((Object)this);
    }

    public boolean isDriving() {
        return this == CAR;
    }

    public boolean isCycling() {
        return this == BICYCLE;
    }

    public boolean isWalking() {
        return this == WALK;
    }

    public static TraverseMode fromTransitMode(TransitMode transitMode) {
        switch (transitMode) {
            case RAIL: 
            case MONORAIL: {
                return RAIL;
            }
            case COACH: 
            case BUS: {
                return BUS;
            }
            case SUBWAY: {
                return SUBWAY;
            }
            case TRAM: {
                return TRAM;
            }
            case FERRY: {
                return FERRY;
            }
            case AIRPLANE: {
                return AIRPLANE;
            }
            case CABLE_CAR: {
                return CABLE_CAR;
            }
            case GONDOLA: {
                return GONDOLA;
            }
            case FUNICULAR: {
                return FUNICULAR;
            }
            case TROLLEYBUS: {
                return TROLLEYBUS;
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        TRANSIT_MODES = EnumSet.of(AIRPLANE, new TraverseMode[]{BUS, CABLE_CAR, FERRY, FUNICULAR, GONDOLA, RAIL, SUBWAY, TRAM, TRANSIT, TROLLEYBUS, MONORAIL});
        STREET_MODES = EnumSet.of(WALK, BICYCLE, SCOOTER, CAR);
    }
}

