/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.StreetEdge;

public class TraversalRequirements {
    public TraverseModeSet modes = TraverseModeSet.allModes();
    private boolean wheelchairAccessible = false;
    private double maxWheelchairSlope = 0.0833333333333;

    public TraversalRequirements() {
    }

    public TraversalRequirements(RoutingRequest options) {
        this();
        if (options == null) {
            return;
        }
        TraversalRequirements.initFromRoutingRequest(this, options);
    }

    private static void initFromRoutingRequest(TraversalRequirements req, RoutingRequest options) {
        req.modes = options.streetSubRequestModes.clone();
        req.wheelchairAccessible = options.wheelchairAccessible;
        req.maxWheelchairSlope = options.maxWheelchairSlope;
    }

    private boolean canBeTraversedInternal(StreetEdge e) {
        if (this.wheelchairAccessible) {
            if (!e.isWheelchairAccessible()) {
                return false;
            }
            if ((double)e.getMaxSlope() > this.maxWheelchairSlope) {
                return false;
            }
        }
        return e.canTraverse(this.modes);
    }

    public boolean canBeTraversed(StreetEdge e) {
        return this.canBeTraversedInternal(e);
    }
}

