/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.opentripplanner.routing.algorithm.astar.NegativeWeightException;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.CarPickupState;
import org.opentripplanner.routing.core.RoutingContext;
import org.opentripplanner.routing.core.StateData;
import org.opentripplanner.routing.core.StateEditor;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.VehicleRentalState;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.edgetype.VehicleRentalEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.VehicleRentalStationVertex;

public class State
implements Cloneable {
    protected long time;
    public double weight = 0.0;
    protected Vertex vertex;
    protected State backState;
    public Edge backEdge;
    protected State next;
    public StateData stateData;
    public double walkDistance;

    public static Collection<State> getInitialStates(RoutingRequest request) {
        ArrayList<State> states = new ArrayList<State>();
        for (Vertex vertex : request.rctx.fromVertices) {
            if (request.carPickup) {
                states.add(new State(vertex, request.rctx.originBackEdge, request.getDateTime().getEpochSecond(), request, true, false, false));
            }
            if (request.vehicleRental && request.arriveBy) {
                states.add(new State(vertex, request.rctx.originBackEdge, request.getDateTime().getEpochSecond(), request, false, true, false));
                if (request.allowKeepingRentedVehicleAtDestination) {
                    states.add(new State(vertex, request.rctx.originBackEdge, request.getDateTime().getEpochSecond(), request, false, true, true));
                }
            }
            states.add(new State(vertex, request.rctx.originBackEdge, request.getDateTime().getEpochSecond(), request));
        }
        return states;
    }

    public State(RoutingRequest opt) {
        this(opt.rctx.fromVertices == null ? null : opt.rctx.fromVertices.iterator().next(), opt.rctx.originBackEdge, opt.getDateTime().getEpochSecond(), opt);
    }

    public State(Vertex vertex, RoutingRequest opt) {
        this(vertex, opt.getDateTime().getEpochSecond(), opt);
    }

    public State(Vertex vertex, long timeSeconds, RoutingRequest options) {
        this(vertex, null, timeSeconds, options);
    }

    public State(Vertex vertex, Edge backEdge, long timeSeconds, RoutingRequest options) {
        this(vertex, backEdge, timeSeconds, timeSeconds, options, false, false, false);
    }

    public State(Vertex vertex, Edge backEdge, long timeSeconds, RoutingRequest options, boolean carPickupStateInCar, boolean bikeRentalFloatingState, boolean keptRentedVehicleAtDestination) {
        this(vertex, backEdge, timeSeconds, timeSeconds, options, carPickupStateInCar, bikeRentalFloatingState, keptRentedVehicleAtDestination);
    }

    public State(Vertex vertex, Edge backEdge, long timeSeconds, long startTime, RoutingRequest options, boolean carPickupStateInCar, boolean vehicleRentalFloatingState, boolean keptRentedVehicleAtDestination) {
        this.vertex = vertex;
        this.backEdge = backEdge;
        this.backState = null;
        this.stateData = new StateData(options);
        this.stateData.opt = options;
        this.stateData.startTime = startTime;
        if (options.vehicleRental) {
            if (options.arriveBy) {
                if (keptRentedVehicleAtDestination) {
                    this.stateData.vehicleRentalState = VehicleRentalState.RENTING_FROM_STATION;
                    this.stateData.currentMode = TraverseMode.BICYCLE;
                    this.stateData.mayKeepRentedVehicleAtDestination = true;
                } else if (vehicleRentalFloatingState) {
                    this.stateData.vehicleRentalState = VehicleRentalState.RENTING_FLOATING;
                    this.stateData.currentMode = TraverseMode.BICYCLE;
                } else {
                    this.stateData.vehicleRentalState = VehicleRentalState.HAVE_RENTED;
                    this.stateData.currentMode = TraverseMode.WALK;
                }
            } else {
                this.stateData.vehicleRentalState = VehicleRentalState.BEFORE_RENTING;
            }
        }
        if (options.carPickup) {
            if (carPickupStateInCar) {
                this.stateData.carPickupState = CarPickupState.IN_CAR;
                this.stateData.currentMode = TraverseMode.CAR;
            } else {
                this.stateData.carPickupState = options.arriveBy ? CarPickupState.WALK_FROM_DROP_OFF : CarPickupState.WALK_TO_PICKUP;
                this.stateData.currentMode = TraverseMode.WALK;
            }
        }
        if (options.parkAndRide) {
            this.stateData.vehicleParked = options.arriveBy;
            this.stateData.currentMode = this.stateData.vehicleParked ? TraverseMode.WALK : (options.streetSubRequestModes.getBicycle() ? TraverseMode.BICYCLE : TraverseMode.CAR);
        }
        this.walkDistance = 0.0;
        this.time = timeSeconds * 1000L;
    }

    public StateEditor edit(Edge e) {
        return new StateEditor(this, e);
    }

    protected State clone() {
        State ret;
        try {
            ret = (State)super.clone();
        }
        catch (CloneNotSupportedException e1) {
            throw new IllegalStateException("This is not happening");
        }
        return ret;
    }

    public String toString() {
        return "<State " + new Date(this.getTimeInMillis()) + " [" + this.weight + "] " + (this.isRentingVehicle() ? "VEHICLE_RENT " : "") + (this.isVehicleParked() ? "VEHICLE_PARKED " : "") + this.vertex + ">";
    }

    public String toStringVerbose() {
        return "<State " + new Date(this.getTimeInMillis()) + " w=" + this.getWeight() + " t=" + this.getElapsedTimeSeconds() + " d=" + this.getWalkDistance() + " r=" + this.isRentingVehicle() + " pr=" + this.isVehicleParked() + ">";
    }

    public CarPickupState getCarPickupState() {
        return this.stateData.carPickupState;
    }

    public long getTimeSeconds() {
        return this.time / 1000L;
    }

    public long getElapsedTimeSeconds() {
        return Math.abs(this.getTimeSeconds() - this.stateData.startTime);
    }

    public boolean isCompatibleVehicleRentalState(State state) {
        return this.stateData.vehicleRentalState == state.stateData.vehicleRentalState && this.stateData.mayKeepRentedVehicleAtDestination == state.stateData.mayKeepRentedVehicleAtDestination;
    }

    public boolean isRentingVehicleFromStation() {
        return this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION;
    }

    public boolean isRentingFloatingVehicle() {
        return this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FLOATING;
    }

    public boolean isRentingVehicle() {
        return this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION || this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FLOATING;
    }

    public boolean vehicleRentalIsFinished() {
        return this.stateData.vehicleRentalState == VehicleRentalState.HAVE_RENTED || this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FLOATING || this.getOptions().allowKeepingRentedVehicleAtDestination && this.stateData.mayKeepRentedVehicleAtDestination && this.stateData.vehicleRentalState == VehicleRentalState.RENTING_FROM_STATION;
    }

    public boolean vehicleRentalNotStarted() {
        return this.stateData.vehicleRentalState == VehicleRentalState.BEFORE_RENTING;
    }

    public VehicleRentalState getVehicleRentalState() {
        return this.stateData.vehicleRentalState;
    }

    public boolean isVehicleParked() {
        return this.stateData.vehicleParked;
    }

    public boolean isFinal() {
        boolean vehicleParkAndRideOk;
        boolean vehicleRentingOk;
        boolean parkAndRide = this.stateData.opt.parkAndRide;
        if (this.stateData.opt.arriveBy) {
            vehicleRentingOk = !this.stateData.opt.vehicleRental || !this.isRentingVehicle();
            vehicleParkAndRideOk = !parkAndRide || !this.isVehicleParked();
        } else {
            vehicleRentingOk = !this.stateData.opt.vehicleRental || this.vehicleRentalNotStarted() || this.vehicleRentalIsFinished();
            vehicleParkAndRideOk = !parkAndRide || this.isVehicleParked();
        }
        return vehicleRentingOk && vehicleParkAndRideOk;
    }

    public double getWalkDistance() {
        return this.walkDistance;
    }

    public Vertex getVertex() {
        return this.vertex;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getTimeDeltaSeconds() {
        return this.backState != null ? (int)(this.getTimeSeconds() - this.backState.getTimeSeconds()) : 0;
    }

    private int getAbsTimeDeltaSeconds() {
        return Math.abs(this.getTimeDeltaSeconds());
    }

    private double getWalkDistanceDelta() {
        if (this.backState != null) {
            return Math.abs(this.walkDistance - this.backState.walkDistance);
        }
        return 0.0;
    }

    public double getWeightDelta() {
        return this.weight - this.backState.weight;
    }

    void checkNegativeWeight() {
        double dw = this.weight - this.backState.weight;
        if (dw < 0.0) {
            throw new NegativeWeightException(String.valueOf(dw) + " on edge " + this.backEdge);
        }
    }

    public State getBackState() {
        return this.backState;
    }

    public TraverseMode getBackMode() {
        return this.stateData.backMode;
    }

    public boolean isBackWalkingBike() {
        return this.stateData.backWalkingBike;
    }

    public Edge getBackEdge() {
        return this.backEdge;
    }

    public long getStartTimeSeconds() {
        return this.stateData.startTime;
    }

    public State getNextResult() {
        return this.next;
    }

    public State addToExistingResultChain(State existingResultChain) {
        if (this.getNextResult() != null) {
            throw new IllegalStateException("this result already has a next result set");
        }
        this.next = existingResultChain;
        return this;
    }

    public RoutingContext getContext() {
        return this.stateData.opt.rctx;
    }

    public RoutingRequest getOptions() {
        return this.stateData.opt;
    }

    public TraverseMode getNonTransitMode() {
        return this.stateData.currentMode;
    }

    private State reversedClone() {
        State newState = new State(this.vertex, this.getTimeSeconds(), this.stateData.opt.reversedClone());
        newState.stateData.vehicleRentalState = this.stateData.vehicleRentalState;
        newState.stateData.vehicleParked = this.stateData.vehicleParked;
        newState.stateData.carPickupState = this.stateData.carPickupState;
        return newState;
    }

    public void dumpPath() {
        System.out.printf("---- FOLLOWING CHAIN OF STATES ----\n", new Object[0]);
        State s = this;
        while (s != null) {
            System.out.printf("%s via %s by %s\n", new Object[]{s, s.backEdge, s.getBackMode()});
            s = s.backState;
        }
        System.out.printf("---- END CHAIN OF STATES ----\n", new Object[0]);
    }

    public long getTimeInMillis() {
        return this.time;
    }

    public boolean multipleOptionsBefore() {
        boolean foundAlternatePaths = false;
        TraverseMode requestedMode = this.getNonTransitMode();
        for (Edge out : this.backState.vertex.getOutgoing()) {
            State outState;
            if (out == this.backEdge || !(out instanceof StreetEdge) || (outState = out.traverse(this.backState)) == null || !outState.getBackMode().equals((Object)requestedMode)) continue;
            Vertex tov = outState.getVertex();
            boolean found = false;
            for (Edge out2 : tov.getOutgoing()) {
                State outState2 = out2.traverse(outState);
                if (outState2 != null && !Objects.equals((Object)outState2.getBackMode(), (Object)requestedMode)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            foundAlternatePaths = true;
            break;
        }
        return foundAlternatePaths;
    }

    public String getVehicleRentalNetwork() {
        return this.stateData.vehicleRentalNetwork;
    }

    public State reverse() {
        State orig = this;
        State ret = orig.reversedClone();
        while (orig.getBackState() != null) {
            VehicleRentalStationVertex stationVertex;
            Edge edge = orig.getBackEdge();
            StateEditor editor = ret.edit(edge);
            editor.setFromState(orig);
            editor.incrementTimeInSeconds(orig.getAbsTimeDeltaSeconds());
            editor.incrementWeight(orig.getWeightDelta());
            editor.incrementWalkDistance(orig.getWalkDistanceDelta());
            editor.setBackMode(orig.getBackMode());
            if (orig.isRentingVehicle() && !orig.getBackState().isRentingVehicle()) {
                stationVertex = (VehicleRentalStationVertex)orig.vertex;
                editor.dropOffRentedVehicleAtStation(((VehicleRentalEdge)edge).formFactor, stationVertex.getStation().getNetwork(), false);
            } else if (!orig.isRentingVehicle() && orig.getBackState().isRentingVehicle()) {
                stationVertex = (VehicleRentalStationVertex)orig.vertex;
                if (orig.getBackState().isRentingVehicleFromStation()) {
                    editor.beginVehicleRentingAtStation(((VehicleRentalEdge)edge).formFactor, stationVertex.getStation().getNetwork(), orig.backState.mayKeepRentedVehicleAtDestination(), false);
                } else if (orig.getBackState().isRentingFloatingVehicle()) {
                    editor.beginFloatingVehicleRenting(((VehicleRentalEdge)edge).formFactor, stationVertex.getStation().getNetwork(), false);
                }
            }
            if (orig.isVehicleParked() != orig.getBackState().isVehicleParked()) {
                editor.setVehicleParked(true, orig.getNonTransitMode());
            }
            ret = editor.makeState();
            orig = orig.getBackState();
        }
        return ret;
    }

    public State optimize() {
        return this.reverse();
    }

    public boolean hasEnteredNoThruTrafficArea() {
        return this.stateData.enteredNoThroughTrafficArea;
    }

    public boolean mayKeepRentedVehicleAtDestination() {
        return this.stateData.mayKeepRentedVehicleAtDestination;
    }
}

