/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Trip;

public class SpecificTransfer
implements Serializable {
    private static final long serialVersionUID = 5058028994896044775L;
    public static final int MIN_SPECIFICITY = 0;
    public static final int MAX_SPECIFICITY = 4;
    private final FeedScopedId fromRouteId;
    private final FeedScopedId toRouteId;
    private final FeedScopedId fromTripId;
    private final FeedScopedId toTripId;
    final int transferTime;

    public SpecificTransfer(FeedScopedId fromRouteId, FeedScopedId toRouteId, FeedScopedId fromTripId, FeedScopedId toTripId, int transferTime) {
        this.fromRouteId = fromRouteId;
        this.toRouteId = toRouteId;
        this.fromTripId = fromTripId;
        this.toTripId = toTripId;
        this.transferTime = transferTime;
    }

    public SpecificTransfer(Route fromRoute, Route toRoute, Trip fromTrip, Trip toTrip, int transferTime) {
        this.fromRouteId = fromRoute != null ? fromRoute.getId() : null;
        this.toRouteId = toRoute != null ? toRoute.getId() : null;
        this.fromTripId = fromTrip != null ? fromTrip.getId() : null;
        this.toTripId = toTrip != null ? toTrip.getId() : null;
        this.transferTime = transferTime;
    }

    public int getSpecificity() {
        int specificity = this.getFromSpecificity() + this.getToSpecificity();
        assert (specificity >= 0);
        assert (specificity <= 4);
        return specificity;
    }

    private int getFromSpecificity() {
        int specificity = 0;
        if (this.fromTripId != null) {
            specificity = 2;
        } else if (this.fromRouteId != null) {
            specificity = 1;
        }
        return specificity;
    }

    private int getToSpecificity() {
        int specificity = 0;
        if (this.toTripId != null) {
            specificity = 2;
        } else if (this.toRouteId != null) {
            specificity = 1;
        }
        return specificity;
    }

    public boolean matches(Trip fromTrip, Trip toTrip) {
        boolean match = this.matchesFrom(fromTrip) && this.matchesTo(toTrip);
        return match;
    }

    private boolean matchesFrom(Trip trip) {
        Preconditions.checkNotNull((Object)trip);
        boolean match = false;
        int specificity = this.getFromSpecificity();
        if (specificity == 0) {
            match = true;
        } else if (specificity == 1) {
            if (trip.getRoute().getId().equals(this.fromRouteId)) {
                match = true;
            }
        } else if (specificity == 2 && trip.getId().equals(this.fromTripId)) {
            match = true;
        }
        return match;
    }

    private boolean matchesTo(Trip trip) {
        Preconditions.checkNotNull((Object)trip);
        boolean match = false;
        int specificity = this.getToSpecificity();
        if (specificity == 0) {
            match = true;
        } else if (specificity == 1) {
            if (trip.getRoute().getId().equals(this.toRouteId)) {
                match = true;
            }
        } else if (specificity == 2 && trip.getId().equals(this.toTripId)) {
            match = true;
        }
        return match;
    }
}

