/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.calendar.ServiceDate;

public class ServiceDay
implements Serializable {
    private static final long serialVersionUID = -1206371243806996680L;
    protected long midnight;
    protected ServiceDate serviceDate;
    protected BitSet serviceIdsRunning;

    public ServiceDay(Map<FeedScopedId, Integer> serviceCodes, ServiceDate serviceDate, CalendarService cs, FeedScopedId agencyId) {
        TimeZone timeZone = cs.getTimeZoneForAgencyId(agencyId);
        this.serviceDate = serviceDate;
        this.init(serviceCodes, cs, timeZone);
    }

    private void init(Map<FeedScopedId, Integer> serviceCodes, CalendarService cs, TimeZone timeZone) {
        Date d = this.serviceDate.getAsDate(timeZone);
        this.midnight = d.getTime() / 1000L;
        this.serviceIdsRunning = new BitSet(cs.getServiceIds().size());
        for (FeedScopedId serviceId : cs.getServiceIdsOnDate(this.serviceDate)) {
            int n = serviceCodes.get(serviceId);
            if (n < 0) continue;
            this.serviceIdsRunning.set(n);
        }
    }

    public boolean serviceRunning(int serviceCode) {
        return this.serviceIdsRunning.get(serviceCode);
    }

    public boolean anyServiceRunning(BitSet serviceCodes) {
        return this.serviceIdsRunning.intersects(serviceCodes);
    }

    public ServiceDate getServiceDate() {
        return this.serviceDate;
    }

    public int secondsSinceMidnight(long time) {
        return (int)(time - this.midnight);
    }

    public long time(int secondsSinceMidnight) {
        return this.midnight + (long)secondsSinceMidnight;
    }

    public String toString() {
        return Long.toString(this.midnight) + Arrays.asList(this.serviceIdsRunning);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServiceDay)) {
            return false;
        }
        ServiceDay other = (ServiceDay)o;
        return other.midnight == this.midnight;
    }

    public int hashCode() {
        return (int)this.midnight;
    }
}

