/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.graph_builder.linking.DisposableEdgeCollection;
import org.opentripplanner.graph_builder.linking.SameEdgeAdjuster;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.routing.algorithm.astar.strategies.EuclideanRemainingWeightHeuristic;
import org.opentripplanner.routing.algorithm.astar.strategies.RemainingWeightHeuristic;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.response.InputField;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.RoutingErrorCode;
import org.opentripplanner.routing.error.GraphNotFoundException;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingContext
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingContext.class);
    public RoutingRequest opt;
    public final Graph graph;
    public final Set<Vertex> fromVertices;
    public final Set<Vertex> toVertices;
    public final Set<FeedScopedId> bannedRoutes;
    private final Set<DisposableEdgeCollection> tempEdges;
    public Edge originBackEdge;
    public RemainingWeightHeuristic remainingWeightHeuristic;
    public boolean aborted;
    public boolean slopeRestrictionRemoved = false;
    public DataOverlayContext dataOverlayContext;

    public RoutingContext(RoutingRequest routingRequest, Graph graph) {
        this(routingRequest, graph, (Vertex)null, null, true);
    }

    public RoutingContext(RoutingRequest routingRequest, Graph graph, Vertex from, Vertex to) {
        this(routingRequest, graph, from, to, false);
    }

    public RoutingContext(RoutingRequest routingRequest, Graph graph, Set<Vertex> from, Set<Vertex> to) {
        this(routingRequest, graph, from, to, false);
    }

    private RoutingContext(RoutingRequest routingRequest, Graph graph, Set<Vertex> from, Set<Vertex> to, boolean findPlaces) {
        Set<Vertex> toVertices;
        Set<Vertex> fromVertices;
        if (graph == null) {
            throw new GraphNotFoundException();
        }
        this.opt = routingRequest;
        this.graph = graph;
        this.tempEdges = new HashSet<DisposableEdgeCollection>();
        this.dataOverlayContext = OTPFeature.DataOverlay.isOnElseNull(() -> new DataOverlayContext(graph.dataOverlayParameterBindings, routingRequest.dataOverlay));
        if (findPlaces) {
            fromVertices = graph.getStreetIndex().getVerticesForLocation(this.opt.from, this.opt, false, this.tempEdges);
            toVertices = graph.getStreetIndex().getVerticesForLocation(this.opt.to, this.opt, true, this.tempEdges);
        } else {
            fromVertices = from;
            toVertices = to;
        }
        this.fromVertices = routingRequest.arriveBy ? toVertices : fromVertices;
        this.toVertices = routingRequest.arriveBy ? fromVertices : toVertices;
        this.bannedRoutes = graph.index != null ? routingRequest.getBannedRoutes(graph.index.getAllRoutes()) : Collections.emptySet();
        if (fromVertices != null && toVertices != null) {
            for (Vertex fromVertex : fromVertices) {
                for (Vertex toVertex : toVertices) {
                    this.tempEdges.add(SameEdgeAdjuster.adjust(fromVertex, toVertex, graph));
                }
            }
        }
        this.remainingWeightHeuristic = new EuclideanRemainingWeightHeuristic();
    }

    private RoutingContext(RoutingRequest routingRequest, Graph graph, Vertex from, Vertex to, boolean findPlaces) {
        this(routingRequest, graph, Collections.singleton(from), Collections.singleton(to), findPlaces);
    }

    public void checkIfVerticesFound() {
        ArrayList<RoutingError> routingErrors = new ArrayList<RoutingError>();
        if (this.opt.from.isSpecified() && this.isDisconnected(this.fromVertices, true)) {
            routingErrors.add(new RoutingError(this.getRoutingErrorCodeForDisconnected(this.opt.from), InputField.FROM_PLACE));
        }
        if (this.opt.to.isSpecified() && this.isDisconnected(this.toVertices, false)) {
            routingErrors.add(new RoutingError(this.getRoutingErrorCodeForDisconnected(this.opt.to), InputField.TO_PLACE));
        }
        if (routingErrors.size() > 0) {
            throw new RoutingValidationException(routingErrors);
        }
    }

    public void destroy() {
        this.tempEdges.forEach(DisposableEdgeCollection::disposeEdges);
    }

    private boolean isDisconnected(Set<Vertex> vertices, boolean isFrom) {
        if (vertices == null) {
            return true;
        }
        Predicate<Vertex> isNotTransit = Predicate.not(TransitStopVertex.class::isInstance);
        Predicate<Vertex> hasNoIncoming = v -> v.getIncoming().isEmpty();
        Predicate<Vertex> hasNoOutgoing = v -> v.getOutgoing().isEmpty();
        Predicate<Vertex> isNotConnected = isFrom == this.opt.arriveBy ? hasNoIncoming : hasNoOutgoing;
        return vertices.stream().allMatch(isNotTransit.and(isNotConnected));
    }

    private RoutingErrorCode getRoutingErrorCodeForDisconnected(GenericLocation location) {
        Coordinate coordinate = location.getCoordinate();
        GeometryFactory gf = GeometryUtils.getGeometryFactory();
        return coordinate != null && this.graph.getConvexHull().disjoint((Geometry)gf.createPoint(coordinate)) ? RoutingErrorCode.OUTSIDE_BOUNDS : RoutingErrorCode.LOCATION_NOT_FOUND;
    }
}

