/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;

public class RouteMatcher
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8066547338465440312L;
    private final HashSet<FeedScopedId> agencyAndRouteIds = new HashSet();
    private final HashSet<T2<String, String>> agencyIdAndRouteNames = new HashSet();
    private final HashSet<String> routeNames = new HashSet();
    private static final RouteMatcher EMPTY_MATCHER = new RouteMatcher();

    private RouteMatcher() {
    }

    private RouteMatcher(Collection<FeedScopedId> routeIds) {
        this.agencyAndRouteIds.addAll(routeIds);
    }

    public static RouteMatcher emptyMatcher() {
        return EMPTY_MATCHER;
    }

    public static RouteMatcher idMatcher(Collection<FeedScopedId> routeIds) {
        return routeIds == null || routeIds.isEmpty() ? RouteMatcher.emptyMatcher() : new RouteMatcher(routeIds);
    }

    public static RouteMatcher parse(String routeSpecList) {
        if (routeSpecList == null) {
            return RouteMatcher.emptyMatcher();
        }
        RouteMatcher retval = new RouteMatcher();
        int n = 0;
        for (String element : routeSpecList.split(",")) {
            String routeId;
            String routeName;
            String agencyId;
            if (element.length() == 0) continue;
            ++n;
            String[] routeSpec = element.split("(?<!\\\\)_", 3);
            if (routeSpec.length != 2 && routeSpec.length != 3) {
                throw new IllegalArgumentException("Wrong route spec format: " + element);
            }
            routeSpec[0] = routeSpec[0].replace("\\_", "_");
            routeSpec[1] = routeSpec[1].replace("\\_", " ");
            if (routeSpec.length >= 3) {
                routeSpec[2] = routeSpec[2].replace("\\_", "_");
            }
            if ((agencyId = routeSpec[0]).length() == 0) {
                agencyId = null;
            }
            if ((routeName = routeSpec[1]).length() == 0) {
                routeName = null;
            }
            String string = routeId = routeSpec.length > 2 ? routeSpec[2] : null;
            if (routeId != null && routeId.length() == 0) {
                routeId = null;
            }
            if (agencyId != null && routeId != null && routeName == null) {
                retval.agencyAndRouteIds.add(new FeedScopedId(agencyId, routeId));
                continue;
            }
            if (agencyId != null && routeName != null && routeId == null) {
                retval.agencyIdAndRouteNames.add(new T2<String, String>(agencyId, routeName));
                continue;
            }
            if (agencyId == null && routeName != null && routeId == null) {
                retval.routeNames.add(routeName);
                continue;
            }
            throw new IllegalArgumentException("Wrong route spec format: " + element);
        }
        if (n == 0) {
            return RouteMatcher.emptyMatcher();
        }
        return retval;
    }

    public boolean matches(Route route) {
        if (this == EMPTY_MATCHER) {
            return false;
        }
        if (this.agencyAndRouteIds.contains(route.getId())) {
            return true;
        }
        if (route.getName() != null) {
            String routeName = route.getName().replace("_", " ");
            if (this.agencyIdAndRouteNames.contains(new T2<String, String>(route.getId().getFeedId(), routeName))) {
                return true;
            }
            if (this.routeNames.contains(routeName)) {
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.agencyAndRouteIds.size() == 0 && this.agencyIdAndRouteNames.size() == 0 && this.routeNames.size() == 0;
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        for (FeedScopedId feedScopedId : this.agencyAndRouteIds) {
            builder.append(feedScopedId.getFeedId() + "__" + feedScopedId.getId());
            builder.append(",");
        }
        for (T2 t2 : this.agencyIdAndRouteNames) {
            builder.append((String)t2.first + "_" + (String)t2.second);
            builder.append(",");
        }
        for (String string : this.routeNames) {
            builder.append("_" + string);
            builder.append(",");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    public String toString() {
        return String.format("RouteMatcher<agencyAndRouteIds=%s agencyIdAndRouteNames=%s routeNames=%s>", this.agencyAndRouteIds, this.agencyIdAndRouteNames, this.routeNames);
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof RouteMatcher)) {
            return false;
        }
        if (another == this) {
            return true;
        }
        RouteMatcher anotherMatcher = (RouteMatcher)another;
        return this.agencyAndRouteIds.equals(anotherMatcher.agencyAndRouteIds) && this.agencyIdAndRouteNames.equals(anotherMatcher.agencyIdAndRouteNames) && this.routeNames.equals(anotherMatcher.routeNames);
    }

    public int hashCode() {
        return this.agencyAndRouteIds.hashCode() + this.agencyIdAndRouteNames.hashCode() + this.routeNames.hashCode();
    }

    public RouteMatcher clone() {
        try {
            return (RouteMatcher)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

