/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;

public class OverlayGraph
implements Serializable {
    private static final long serialVersionUID = 20111106L;
    private static final int INITIAL_EDGELIST_CAPACITY = 5;
    private IdentityHashMap<Vertex, List<Edge>> outgoing = new IdentityHashMap();
    private IdentityHashMap<Vertex, List<Edge>> incoming = new IdentityHashMap();

    public OverlayGraph() {
    }

    public OverlayGraph(Graph g) {
        this();
        for (Vertex v : g.getVertices()) {
            for (Edge e : v.getOutgoing()) {
                this.addOutgoing(v, e);
            }
            for (Edge e : v.getIncoming()) {
                this.addIncoming(v, e);
            }
        }
    }

    public void addOutgoing(Vertex fromv, Edge e) {
        List<Edge> fromOutgoing = this.outgoing.get(fromv);
        if (fromOutgoing == null) {
            fromOutgoing = new ArrayList<Edge>(5);
            this.outgoing.put(fromv, fromOutgoing);
        }
        if (!fromOutgoing.contains(e)) {
            fromOutgoing.add(e);
        }
    }

    public void addIncoming(Vertex tov, Edge e) {
        List<Edge> toIncoming = this.incoming.get(tov);
        if (toIncoming == null) {
            toIncoming = new ArrayList<Edge>(5);
            this.incoming.put(tov, toIncoming);
        }
        if (!toIncoming.contains(e)) {
            toIncoming.add(e);
        }
    }

    public void removeOutgoing(Vertex fromv, Edge e) {
        List<Edge> fromOutgoing = this.outgoing.get(fromv);
        if (fromOutgoing != null) {
            fromOutgoing.remove(e);
        }
    }

    public void removeIncoming(Vertex tov, Edge e) {
        List<Edge> toIncoming = this.incoming.get(tov);
        if (toIncoming != null) {
            toIncoming.remove(e);
        }
    }

    public void addEdge(Edge e) {
        Vertex fromv = e.getFromVertex();
        Vertex tov = e.getToVertex();
        this.addOutgoing(fromv, e);
        this.addIncoming(tov, e);
    }

    public void removeEdge(Edge e) {
        Vertex fromv = e.getFromVertex();
        Vertex tov = e.getToVertex();
        this.removeOutgoing(fromv, e);
        this.removeIncoming(tov, e);
    }

    public List<Edge> getOutgoing(Vertex v) {
        List<Edge> ret = this.outgoing.get(v);
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public List<Edge> getIncoming(Vertex v) {
        List<Edge> ret = this.incoming.get(v);
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public int countEdges() {
        HashSet<Edge> eset = new HashSet<Edge>(1000);
        for (List<Edge> l : this.outgoing.values()) {
            for (Edge e : l) {
                eset.add(e);
            }
        }
        for (List<Edge> l : this.incoming.values()) {
            for (Edge e : l) {
                eset.add(e);
            }
        }
        return eset.size();
    }

    public Collection<Vertex> getVertices() {
        HashSet<Vertex> sv = new HashSet<Vertex>();
        sv.addAll(this.outgoing.keySet());
        sv.addAll(this.incoming.keySet());
        return sv;
    }

    public int countVertices() {
        return this.getVertices().size();
    }

    public void removeVertex(Vertex vertex) {
        this.outgoing.remove(vertex);
        this.incoming.remove(vertex);
    }

    public int getDegreeIn(Vertex v) {
        List<Edge> l = this.incoming.get(v);
        if (l == null) {
            return 0;
        }
        return l.size();
    }

    public int getDegreeOut(Vertex v) {
        List<Edge> l = this.outgoing.get(v);
        if (l == null) {
            return 0;
        }
        return l.size();
    }

    public boolean containsVertex(Vertex vertex) {
        return this.outgoing.containsKey(vertex) || this.incoming.containsKey(vertex);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        for (List<Edge> le : this.outgoing.values()) {
            ((ArrayList)le).trimToSize();
        }
        for (List<Edge> le : this.incoming.values()) {
            ((ArrayList)le).trimToSize();
        }
        out.defaultWriteObject();
    }
}

