/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.common.model.P2;
import org.opentripplanner.model.FareAttribute;
import org.opentripplanner.model.FeedScopedId;

public class FareRuleSet
implements Serializable {
    private static final long serialVersionUID = 7218355718876553028L;
    private Set<FeedScopedId> routes;
    private Set<P2<String>> originDestinations;
    private Set<String> contains;
    private FareAttribute fareAttribute;
    private Set<FeedScopedId> trips;

    public FareRuleSet(FareAttribute fareAttribute) {
        this.fareAttribute = fareAttribute;
        this.routes = new HashSet<FeedScopedId>();
        this.originDestinations = new HashSet<P2<String>>();
        this.contains = new HashSet<String>();
        this.trips = new HashSet<FeedScopedId>();
    }

    public void addOriginDestination(String origin, String destination) {
        this.originDestinations.add(new P2<String>(origin, destination));
    }

    public Set<P2<String>> getOriginDestinations() {
        return this.originDestinations;
    }

    public void addContains(String containsId) {
        this.contains.add(containsId);
    }

    public void addRoute(FeedScopedId route) {
        this.routes.add(route);
    }

    public Set<FeedScopedId> getRoutes() {
        return this.routes;
    }

    public FareAttribute getFareAttribute() {
        return this.fareAttribute;
    }

    public void addTrip(FeedScopedId trip) {
        this.trips.add(trip);
    }

    public Set<FeedScopedId> getTrips() {
        return this.trips;
    }

    public boolean matches(String startZone, String endZone, Set<String> zonesVisited, Set<FeedScopedId> routesVisited, Set<FeedScopedId> tripsVisited) {
        P2<Object> od2;
        P2<String> od;
        if (!(this.originDestinations.size() <= 0 || this.originDestinations.contains(od = new P2<String>(startZone, endZone)) || this.originDestinations.contains(od2 = new P2<Object>(((String)od.first), null)) || this.originDestinations.contains(od2 = new P2<String>(null, (String)od.first)))) {
            return false;
        }
        if (this.contains.size() > 0 && !zonesVisited.equals(this.contains)) {
            return false;
        }
        if (this.routes.size() != 0 && !this.routes.containsAll(routesVisited)) {
            return false;
        }
        return this.trips.size() == 0 || this.trips.containsAll(tripsVisited);
    }
}

