/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opentripplanner.routing.core.FareComponent;
import org.opentripplanner.routing.core.Money;
import org.opentripplanner.routing.core.WrappedCurrency;

public class Fare {
    public HashMap<FareType, Money> fare = new HashMap();
    public HashMap<FareType, FareComponent[]> details = new HashMap();

    public Fare() {
    }

    public Fare(Fare aFare) {
        this();
        if (aFare != null) {
            for (Map.Entry<FareType, Money> kv : aFare.fare.entrySet()) {
                this.fare.put(kv.getKey(), new Money(kv.getValue().getCurrency(), kv.getValue().getCents()));
            }
        }
    }

    public void addFare(FareType fareType, WrappedCurrency currency, int cents) {
        this.fare.put(fareType, new Money(currency, cents));
    }

    public void addFare(FareType fareType, Money money) {
        this.fare.put(fareType, money);
    }

    public void addFareDetails(FareType fareType, List<FareComponent> newDetails) {
        this.details.put(fareType, newDetails.toArray(new FareComponent[newDetails.size()]));
    }

    public Money getFare(FareType type) {
        return this.fare.get(type);
    }

    public List<FareComponent> getDetails(FareType type) {
        return Arrays.asList(this.details.get(type));
    }

    public void addCost(int surcharge) {
        for (Money cost : this.fare.values()) {
            int cents = cost.getCents();
            cost.setCents(cents + surcharge);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Fare(");
        for (FareType type : this.fare.keySet()) {
            Money cost = this.fare.get(type);
            buffer.append("[");
            buffer.append(type.toString());
            buffer.append(":");
            buffer.append(cost.toString());
            buffer.append("], ");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static enum FareType implements Serializable
    {
        regular,
        student,
        senior,
        tram,
        special,
        youth;

    }
}

