/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.response;

import java.util.List;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.model.plan.TripPlan;
import org.opentripplanner.model.plan.pagecursor.PageCursor;
import org.opentripplanner.routing.api.response.RoutingError;
import org.opentripplanner.routing.api.response.TripSearchMetadata;
import org.opentripplanner.routing.framework.DebugTimingAggregator;

public class RoutingResponse {
    private final TripPlan tripPlan;
    private final PageCursor nextPageCursor;
    private final PageCursor previousPageCursor;
    private final TripSearchMetadata metadata;
    private final List<RoutingError> routingErrors;
    private final DebugTimingAggregator debugTimingAggregator;

    public RoutingResponse(TripPlan tripPlan, PageCursor previousPageCursor, PageCursor nextPageCursor, TripSearchMetadata metadata, List<RoutingError> routingErrors, DebugTimingAggregator debugTimingAggregator) {
        this.tripPlan = tripPlan;
        this.nextPageCursor = nextPageCursor;
        this.previousPageCursor = previousPageCursor;
        this.metadata = metadata;
        this.routingErrors = routingErrors;
        this.debugTimingAggregator = debugTimingAggregator;
    }

    public TripPlan getTripPlan() {
        return this.tripPlan;
    }

    public PageCursor getNextPageCursor() {
        return this.nextPageCursor;
    }

    public PageCursor getPreviousPageCursor() {
        return this.previousPageCursor;
    }

    public TripSearchMetadata getMetadata() {
        return this.metadata;
    }

    public DebugTimingAggregator getDebugTimingAggregator() {
        return this.debugTimingAggregator;
    }

    public List<RoutingError> getRoutingErrors() {
        return this.routingErrors;
    }

    public String toString() {
        return ToStringBuilder.of(RoutingResponse.class).addObj("tripPlan", this.tripPlan).addObj("nextPageCursor", this.nextPageCursor).addObj("previousPageCursor", this.previousPageCursor).addObj("metadata", this.metadata).addObj("routingErrors", this.routingErrors).toString();
    }
}

