/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.geotools.geojson.geom.GeometryJSON;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opentripplanner.api.common.LocationStringParser;
import org.opentripplanner.common.geometry.SphericalDistanceLibrary;
import org.opentripplanner.ext.dataoverlay.api.DataOverlayParameters;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.modes.AllowedTransitMode;
import org.opentripplanner.model.plan.SortOrder;
import org.opentripplanner.model.plan.pagecursor.PageCursor;
import org.opentripplanner.model.plan.pagecursor.PageType;
import org.opentripplanner.routing.algorithm.transferoptimization.api.TransferOptimizationParameters;
import org.opentripplanner.routing.api.request.BannedStopSet;
import org.opentripplanner.routing.api.request.DebugRaptor;
import org.opentripplanner.routing.api.request.ItineraryFilterParameters;
import org.opentripplanner.routing.api.request.RequestModes;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.TransferOptimizationRequest;
import org.opentripplanner.routing.core.BicycleOptimizeType;
import org.opentripplanner.routing.core.RouteMatcher;
import org.opentripplanner.routing.core.RoutingContext;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.core.intersection_model.IntersectionTraversalCostModel;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.DurationComparator;
import org.opentripplanner.routing.impl.PathComparator;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.spt.ShortestPathTree;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.util.time.DateUtils;
import org.opentripplanner.util.time.DurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingRequest
implements AutoCloseable,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RoutingRequest.class);
    private static final long NOW_THRESHOLD_SEC = DurationUtils.durationInSeconds("15h");
    public final HashMap<String, String> parameters = new HashMap();
    public GenericLocation from;
    public GenericLocation to;
    @Deprecated
    public boolean oneToMany = false;
    @Deprecated
    public List<GenericLocation> intermediatePlaces;
    public double maxDirectStreetDurationSeconds = Duration.ofHours(4L).toSeconds();
    public double maxAccessEgressDurationSeconds = Duration.ofMinutes(45L).toSeconds();
    public Map<StreetMode, Double> maxAccessEgressDurationSecondsForMode = new HashMap<StreetMode, Double>();
    public RequestModes modes = new RequestModes(StreetMode.WALK, StreetMode.WALK, StreetMode.WALK, StreetMode.WALK, AllowedTransitMode.getAllTransitModes());
    public TraverseModeSet streetSubRequestModes = new TraverseModeSet(TraverseMode.WALK);
    public BicycleOptimizeType bicycleOptimizeType = BicycleOptimizeType.SAFE;
    private Instant dateTime = Instant.now();
    public Duration searchWindow;
    public Duration maxJourneyDuration = Duration.ofHours(24L);
    public PageCursor pageCursor;
    public boolean timetableView = true;
    public boolean arriveBy = false;
    public boolean wheelchairAccessible = false;
    public int numItineraries = 50;
    public double maxWheelchairSlope = 0.0833333333333;
    public boolean showIntermediateStops = false;
    public double walkSpeed = 1.33;
    public double bikeSpeed = 5.0;
    public double bikeWalkingSpeed = 1.33;
    public double carSpeed = 40.0;
    public Locale locale = new Locale("en", "US");
    public int transferCost = 0;
    @Deprecated
    public int nonpreferredTransferCost = 180;
    public final TransferOptimizationParameters transferOptimization = new TransferOptimizationRequest();
    private Map<TransitMode, Double> transitReluctanceForMode = new HashMap<TransitMode, Double>();
    public double walkReluctance = 2.0;
    public double bikeWalkingReluctance = 5.0;
    public double bikeReluctance = 2.0;
    public double carReluctance = 2.0;
    public double stairsTimeFactor = 3.0;
    public double stairsReluctance = 2.0;
    public double turnReluctance = 1.0;
    public int elevatorBoardTime = 90;
    public int elevatorBoardCost = 90;
    public int elevatorHopTime = 20;
    public int elevatorHopCost = 20;
    public int bikeSwitchTime;
    public int bikeSwitchCost;
    public int vehicleRentalPickupTime = 60;
    public int vehicleRentalPickupCost = 120;
    public int vehicleRentalDropoffTime = 30;
    public int vehicleRentalDropoffCost = 30;
    public Set<String> allowedVehicleRentalNetworks = Set.of();
    public Set<String> bannedVehicleRentalNetworks = Set.of();
    public int bikeParkTime = 60;
    public int bikeParkCost = 120;
    public int carParkTime = 60;
    public int carParkCost = 120;
    public Set<String> requiredVehicleParkingTags = Set.of();
    public Set<String> bannedVehicleParkingTags = Set.of();
    public int carDropoffTime = 120;
    public int carPickupTime = 60;
    public int carPickupCost = 120;
    public double waitReluctance = 1.0;
    @Deprecated
    public double waitAtBeginningFactor = 0.4;
    public int walkBoardCost = 600;
    public int bikeBoardCost = 600;
    private Set<FeedScopedId> bannedAgencies = Set.of();
    private Set<FeedScopedId> whiteListedAgencies = Set.of();
    @Deprecated
    private Set<FeedScopedId> preferredAgencies = Set.of();
    @Deprecated
    private Set<FeedScopedId> unpreferredAgencies = Set.of();
    private RouteMatcher bannedRoutes = RouteMatcher.emptyMatcher();
    private RouteMatcher whiteListedRoutes = RouteMatcher.emptyMatcher();
    @Deprecated
    private RouteMatcher preferredRoutes = RouteMatcher.emptyMatcher();
    @Deprecated
    public int otherThanPreferredRoutesPenalty = 300;
    @Deprecated
    private RouteMatcher unpreferredRoutes = RouteMatcher.emptyMatcher();
    @Deprecated
    public int useUnpreferredRoutesPenalty = 300;
    @Deprecated
    public HashMap<FeedScopedId, BannedStopSet> bannedTrips = new HashMap();
    public int transferSlack = 120;
    public int boardSlack = 0;
    public Map<TransitMode, Integer> boardSlackForMode = new EnumMap<TransitMode, Integer>(TransitMode.class);
    public int alightSlack = 0;
    public Map<TransitMode, Integer> alightSlackForMode = new EnumMap<TransitMode, Integer>(TransitMode.class);
    public Integer maxTransfers = 12;
    public double bikeTriangleTimeFactor;
    public double bikeTriangleSlopeFactor;
    public double bikeTriangleSafetyFactor;
    public boolean useVehicleRentalAvailabilityInformation = false;
    public boolean allowKeepingRentedVehicleAtDestination = false;
    public double keepingRentedVehicleAtDestinationCost = 0.0;
    public double carDecelerationSpeed = 2.9;
    public double carAccelerationSpeed = 2.9;
    public boolean ignoreRealtimeUpdates = false;
    public boolean includePlannedCancellations = false;
    public boolean disableRemainingWeightHeuristic = false;
    public RoutingContext rctx;
    @Deprecated
    public FeedScopedId startingTransitStopId;
    @Deprecated
    public FeedScopedId startingTransitTripId;
    public boolean vehicleRental = false;
    public boolean parkAndRide = false;
    public boolean carPickup = false;
    public Set<RentalVehicleType.FormFactor> allowedRentalFormFactors = new HashSet<RentalVehicleType.FormFactor>();
    public boolean useVehicleParkingAvailabilityInformation = false;
    public DominanceFunction dominanceFunction = new DominanceFunction.Pareto();
    @Deprecated
    public boolean onlyTransitTrips = false;
    @Deprecated
    public boolean disableAlertFiltering = false;
    public boolean geoidElevation = false;
    @Deprecated
    public String pathComparator = null;
    @Nonnull
    public ItineraryFilterParameters itineraryFilters = ItineraryFilterParameters.createDefault();
    public DataOverlayParameters dataOverlay = null;
    public DebugRaptor raptorDebuging = null;
    private static final int MAX_CLOSENESS_METERS = 500;
    private Envelope fromEnvelope;
    private Envelope toEnvelope;

    public RoutingRequest() {
        this.from = new GenericLocation(null, null);
        this.to = new GenericLocation(null, null);
    }

    public RoutingRequest(TraverseModeSet streetSubRequestModes) {
        this();
        this.setStreetSubRequestModes(streetSubRequestModes);
    }

    public RoutingRequest(TraverseMode mode) {
        this();
        this.setStreetSubRequestModes(new TraverseModeSet(mode));
    }

    public RoutingRequest(TraverseMode mode, BicycleOptimizeType bicycleOptimizeType) {
        this(new TraverseModeSet(mode), bicycleOptimizeType);
    }

    public RoutingRequest(TraverseModeSet modeSet, BicycleOptimizeType bicycleOptimizeType) {
        this();
        this.bicycleOptimizeType = bicycleOptimizeType;
        this.setStreetSubRequestModes(modeSet);
    }

    public RoutingRequest(RequestModes modes) {
        this();
        this.modes = modes;
    }

    public boolean transitAllowed() {
        return this.streetSubRequestModes.isTransit();
    }

    public void setArriveBy(boolean arriveBy) {
        this.arriveBy = arriveBy;
    }

    public void setMode(TraverseMode mode) {
        this.setStreetSubRequestModes(new TraverseModeSet(mode));
    }

    public void setStreetSubRequestModes(TraverseModeSet streetSubRequestModes) {
        this.streetSubRequestModes = streetSubRequestModes;
    }

    public void setBicycleOptimizeType(BicycleOptimizeType bicycleOptimizeType) {
        this.bicycleOptimizeType = bicycleOptimizeType;
    }

    public void setWheelchairAccessible(boolean wheelchairAccessible) {
        this.wheelchairAccessible = wheelchairAccessible;
    }

    public void setTransitReluctanceForMode(Map<TransitMode, Double> reluctanceForMode) {
        this.transitReluctanceForMode.clear();
        this.transitReluctanceForMode.putAll(reluctanceForMode);
    }

    public Map<TransitMode, Double> transitReluctanceForMode() {
        return Collections.unmodifiableMap(this.transitReluctanceForMode);
    }

    public void setWalkBoardCost(int walkBoardCost) {
        this.walkBoardCost = walkBoardCost < 0 ? 0 : walkBoardCost;
    }

    public void setBikeBoardCost(int bikeBoardCost) {
        this.bikeBoardCost = bikeBoardCost < 0 ? 0 : bikeBoardCost;
    }

    public void setPreferredAgencies(Collection<FeedScopedId> ids) {
        if (ids != null) {
            this.preferredAgencies = Set.copyOf(ids);
        }
    }

    public void setPreferredAgenciesFromString(String s) {
        if (!s.isEmpty()) {
            this.preferredAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    public void setUnpreferredAgencies(Collection<FeedScopedId> ids) {
        if (ids != null) {
            this.unpreferredAgencies = Set.copyOf(ids);
        }
    }

    public void setUnpreferredAgenciesFromString(String s) {
        if (!s.isEmpty()) {
            this.unpreferredAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    public void setBannedAgencies(Collection<FeedScopedId> ids) {
        if (ids != null) {
            this.bannedAgencies = Set.copyOf(ids);
        }
    }

    public void setBannedAgenciesFromSting(String s) {
        if (!s.isEmpty()) {
            this.bannedAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    public void setWhiteListedAgencies(Collection<FeedScopedId> ids) {
        if (ids != null) {
            this.whiteListedAgencies = Set.copyOf(ids);
        }
    }

    public void setWhiteListedAgenciesFromSting(String s) {
        if (!s.isEmpty()) {
            this.whiteListedAgencies = FeedScopedId.parseListOfIds(s);
        }
    }

    public void setOtherThanPreferredRoutesPenalty(int penalty) {
        if (penalty < 0) {
            penalty = 0;
        }
        this.otherThanPreferredRoutesPenalty = penalty;
    }

    public void setPreferredRoutes(List<FeedScopedId> routeIds) {
        this.preferredRoutes = RouteMatcher.idMatcher(routeIds);
    }

    public void setPreferredRoutesFromSting(String s) {
        this.preferredRoutes = !s.isEmpty() ? RouteMatcher.parse(s) : RouteMatcher.emptyMatcher();
    }

    public void setUnpreferredRoutes(List<FeedScopedId> routeIds) {
        this.unpreferredRoutes = RouteMatcher.idMatcher(routeIds);
    }

    public void setUnpreferredRoutesFromSting(String s) {
        this.unpreferredRoutes = !s.isEmpty() ? RouteMatcher.parse(s) : RouteMatcher.emptyMatcher();
    }

    public void setBannedRoutes(List<FeedScopedId> routeIds) {
        this.bannedRoutes = RouteMatcher.idMatcher(routeIds);
    }

    public void setBannedRoutesFromSting(String s) {
        this.bannedRoutes = !s.isEmpty() ? RouteMatcher.parse(s) : RouteMatcher.emptyMatcher();
    }

    public void setWhiteListedRoutesFromSting(String s) {
        this.whiteListedRoutes = !s.isEmpty() ? RouteMatcher.parse(s) : RouteMatcher.emptyMatcher();
    }

    public void setWhiteListedRoutes(List<FeedScopedId> routeIds) {
        this.whiteListedRoutes = RouteMatcher.idMatcher(routeIds);
    }

    public void setFromString(String from) {
        this.from = LocationStringParser.fromOldStyleString(from);
    }

    public void setToString(String to) {
        this.to = LocationStringParser.fromOldStyleString(to);
    }

    public void addMode(TraverseMode mode) {
        this.streetSubRequestModes.setMode(mode, true);
    }

    public Instant getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(Instant dateTime) {
        this.dateTime = dateTime;
    }

    public void setDateTime(String date, String time, TimeZone tz) {
        Date dateObject = DateUtils.toDate(date, time, tz);
        this.setDateTime(dateObject == null ? Instant.now() : dateObject.toInstant());
    }

    public boolean isTripPlannedForNow() {
        return Duration.between(this.dateTime, Instant.now()).abs().toSeconds() < NOW_THRESHOLD_SEC;
    }

    public int getNumItinerariesForDirectStreetSearch() {
        return 1;
    }

    public void setPageCursor(String pageCursor) {
        this.pageCursor = PageCursor.decode(pageCursor);
    }

    public SortOrder getItinerariesSortOrder() {
        if (this.pageCursor != null) {
            return this.pageCursor.originalSortOrder;
        }
        return this.arriveBy ? SortOrder.STREET_AND_DEPARTURE_TIME : SortOrder.STREET_AND_ARRIVAL_TIME;
    }

    public void applyPageCursor() {
        if (this.pageCursor != null) {
            if (this.pageCursor.latestArrivalTime == null) {
                this.arriveBy = false;
            }
            this.setDateTime(this.arriveBy ? this.pageCursor.latestArrivalTime : this.pageCursor.earliestDepartureTime);
            this.modes.directMode = StreetMode.NOT_SET;
            LOG.debug("Request dateTime={} set from pageCursor.", (Object)this.dateTime);
        }
    }

    public boolean maxNumberOfItinerariesCropHead() {
        if (this.pageCursor == null) {
            return false;
        }
        boolean previousPage = this.pageCursor.type == PageType.PREVIOUS_PAGE;
        return this.pageCursor.originalSortOrder.isSortedByArrivalTimeAcceding() == previousPage;
    }

    public boolean doCropSearchWindowAtTail() {
        if (this.pageCursor == null) {
            return this.getItinerariesSortOrder().isSortedByArrivalTimeAcceding();
        }
        return this.pageCursor.type == PageType.NEXT_PAGE;
    }

    public void setNumItineraries(int numItineraries) {
        this.numItineraries = numItineraries;
    }

    public String toString() {
        return this.toString(" ");
    }

    public String toString(String sep) {
        return this.from + sep + this.to + sep + this.dateTime + sep + this.arriveBy + sep + this.bicycleOptimizeType + sep + this.streetSubRequestModes.getAsStr() + sep + this.getNumItinerariesForDirectStreetSearch();
    }

    public void removeMode(TraverseMode mode) {
        this.streetSubRequestModes.setMode(mode, false);
    }

    public void setIntermediatePlacesFromStrings(List<String> intermediates) {
        this.intermediatePlaces = new ArrayList<GenericLocation>(intermediates.size());
        for (String place : intermediates) {
            this.intermediatePlaces.add(LocationStringParser.fromOldStyleString(place));
        }
    }

    public void clearIntermediatePlaces() {
        if (this.intermediatePlaces != null) {
            this.intermediatePlaces.clear();
        }
    }

    public boolean hasIntermediatePlaces() {
        return this.intermediatePlaces != null && this.intermediatePlaces.size() > 0;
    }

    public void addIntermediatePlace(GenericLocation location) {
        if (this.intermediatePlaces == null) {
            this.intermediatePlaces = new ArrayList<GenericLocation>();
        }
        this.intermediatePlaces.add(location);
    }

    public RoutingRequest getStreetSearchRequest(StreetMode streetMode) {
        RoutingRequest streetRequest = this.clone();
        streetRequest.streetSubRequestModes = new TraverseModeSet(new TraverseMode[0]);
        if (streetMode != null) {
            switch (streetMode) {
                case WALK: 
                case FLEXIBLE: {
                    streetRequest.setStreetSubRequestModes(new TraverseModeSet(TraverseMode.WALK));
                    break;
                }
                case BIKE: {
                    streetRequest.setStreetSubRequestModes(new TraverseModeSet(TraverseMode.BICYCLE));
                    break;
                }
                case BIKE_TO_PARK: {
                    streetRequest.setStreetSubRequestModes(new TraverseModeSet(TraverseMode.BICYCLE, TraverseMode.WALK));
                    streetRequest.parkAndRide = true;
                    break;
                }
                case BIKE_RENTAL: {
                    streetRequest.setStreetSubRequestModes(new TraverseModeSet(TraverseMode.BICYCLE, TraverseMode.WALK));
                    streetRequest.vehicleRental = true;
                    streetRequest.allowedRentalFormFactors.add(RentalVehicleType.FormFactor.BICYCLE);
                    break;
                }
                case SCOOTER_RENTAL: {
                    streetRequest.setStreetSubRequestModes(new TraverseModeSet(TraverseMode.BICYCLE, TraverseMode.WALK));
                    streetRequest.vehicleRental = true;
                    streetRequest.allowedRentalFormFactors.add(RentalVehicleType.FormFactor.SCOOTER);
                    break;
                }
                case CAR: {
                    streetRequest.setStreetSubRequestModes(new TraverseModeSet(TraverseMode.CAR));
                    break;
                }
                case CAR_TO_PARK: {
                    streetRequest.setStreetSubRequestModes(new TraverseModeSet(TraverseMode.CAR, TraverseMode.WALK));
                    streetRequest.parkAndRide = true;
                    break;
                }
                case CAR_PICKUP: {
                    streetRequest.setStreetSubRequestModes(new TraverseModeSet(TraverseMode.CAR, TraverseMode.WALK));
                    streetRequest.carPickup = true;
                    break;
                }
                case CAR_RENTAL: {
                    streetRequest.setStreetSubRequestModes(new TraverseModeSet(TraverseMode.CAR, TraverseMode.WALK));
                    streetRequest.vehicleRental = true;
                    streetRequest.allowedRentalFormFactors.add(RentalVehicleType.FormFactor.CAR);
                }
            }
        }
        streetRequest.resetRoutingContext();
        return streetRequest;
    }

    private void resetRoutingContext() {
        if (this.rctx != null) {
            Graph graph = this.rctx.graph;
            this.rctx = null;
            this.setRoutingContext(graph);
        }
    }

    public RoutingRequest clone() {
        try {
            RoutingRequest clone = (RoutingRequest)super.clone();
            clone.streetSubRequestModes = this.streetSubRequestModes.clone();
            clone.allowedVehicleRentalNetworks = Set.copyOf(this.allowedVehicleRentalNetworks);
            clone.bannedVehicleRentalNetworks = Set.copyOf(this.bannedVehicleRentalNetworks);
            clone.requiredVehicleParkingTags = Set.copyOf(this.requiredVehicleParkingTags);
            clone.bannedVehicleParkingTags = Set.copyOf(this.bannedVehicleParkingTags);
            clone.preferredAgencies = Set.copyOf(this.preferredAgencies);
            clone.unpreferredAgencies = Set.copyOf(this.unpreferredAgencies);
            clone.whiteListedAgencies = Set.copyOf(this.whiteListedAgencies);
            clone.bannedAgencies = Set.copyOf(this.bannedAgencies);
            clone.bannedRoutes = this.bannedRoutes.clone();
            clone.whiteListedRoutes = this.whiteListedRoutes.clone();
            clone.preferredRoutes = this.preferredRoutes.clone();
            clone.unpreferredRoutes = this.unpreferredRoutes.clone();
            clone.bannedTrips = (HashMap)this.bannedTrips.clone();
            clone.allowedRentalFormFactors = new HashSet<RentalVehicleType.FormFactor>(this.allowedRentalFormFactors);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public RoutingRequest reversedClone() {
        RoutingRequest ret = this.clone();
        ret.setArriveBy(!ret.arriveBy);
        ret.useVehicleRentalAvailabilityInformation = false;
        return ret;
    }

    public void setRoutingContext(Graph graph) {
        if (this.rctx != null) {
            if (this.rctx.graph == graph) {
                LOG.debug("keeping existing routing context");
                return;
            }
            LOG.error("attempted to reset routing context using a different graph");
            return;
        }
        this.rctx = new RoutingContext(this, graph);
        this.rctx.checkIfVerticesFound();
    }

    public void setRoutingContext(Graph graph, Edge fromBackEdge, Vertex from, Vertex to) {
        if (this.rctx != null) {
            this.rctx.destroy();
        }
        this.rctx = new RoutingContext(this, graph, from, to);
        this.rctx.originBackEdge = fromBackEdge;
    }

    public void setRoutingContext(Graph graph, Vertex from, Vertex to) {
        this.setRoutingContext(graph, null, from, to);
    }

    public void setRoutingContext(Graph graph, Set<Vertex> from, Set<Vertex> to) {
        this.setRoutingContext(graph, null, from, to);
    }

    public void setRoutingContext(Graph graph, Edge fromBackEdge, Set<Vertex> from, Set<Vertex> to) {
        if (this.rctx != null) {
            this.rctx.destroy();
        }
        this.rctx = new RoutingContext(this, graph, from, to);
        this.rctx.originBackEdge = fromBackEdge;
    }

    public void setRoutingContext(Graph graph, String from, String to) {
        this.setRoutingContext(graph, graph.getVertex(from), graph.getVertex(to));
    }

    public void setDummyRoutingContext(Graph graph) {
        this.setRoutingContext(graph, "", "");
    }

    public RoutingContext getRoutingContext() {
        return this.rctx;
    }

    public void cleanup() {
        if (this.rctx != null) {
            try {
                this.rctx.destroy();
            }
            catch (Exception e) {
                LOG.error("Could not destroy the routing context", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        this.cleanup();
    }

    public double getReluctance(TraverseMode mode, boolean walkingBike) {
        switch (mode) {
            case WALK: {
                return walkingBike ? this.bikeWalkingReluctance : this.walkReluctance;
            }
            case BICYCLE: {
                return this.bikeReluctance;
            }
            case CAR: {
                return this.carReluctance;
            }
        }
        throw new IllegalArgumentException("getReluctance(): Invalid mode " + mode);
    }

    public double getSpeed(TraverseMode mode, boolean walkingBike) {
        switch (mode) {
            case WALK: {
                return walkingBike ? this.bikeWalkingSpeed : this.walkSpeed;
            }
            case BICYCLE: {
                return this.bikeSpeed;
            }
            case CAR: {
                return this.carSpeed;
            }
        }
        throw new IllegalArgumentException("getSpeed(): Invalid mode " + mode);
    }

    public double getStreetSpeedUpperBound() {
        if (this.streetSubRequestModes.getCar()) {
            return this.carSpeed;
        }
        if (this.streetSubRequestModes.getBicycle()) {
            return this.bikeSpeed;
        }
        return this.walkSpeed;
    }

    public void setBikeReluctance(double bikeReluctance) {
        if (bikeReluctance > 0.0) {
            this.bikeReluctance = bikeReluctance;
        }
    }

    public void setBikeWalkingReluctance(double bikeWalkingReluctance) {
        if (bikeWalkingReluctance > 0.0) {
            this.bikeWalkingReluctance = bikeWalkingReluctance;
        }
    }

    public void setCarReluctance(double carReluctance) {
        if (carReluctance > 0.0) {
            this.carReluctance = carReluctance;
        }
    }

    public void setWalkReluctance(double walkReluctance) {
        if (walkReluctance > 0.0) {
            this.walkReluctance = walkReluctance;
        }
    }

    public void setNonTransitReluctance(double nonTransitReluctance) {
        if (nonTransitReluctance > 0.0) {
            this.bikeReluctance = nonTransitReluctance;
            this.walkReluctance = nonTransitReluctance;
            this.carReluctance = nonTransitReluctance;
            this.bikeWalkingReluctance = nonTransitReluctance * 2.7;
        }
    }

    public void setWaitReluctance(double waitReluctance) {
        if (waitReluctance > 0.0) {
            this.waitReluctance = waitReluctance;
        }
    }

    public void setWaitAtBeginningFactor(double waitAtBeginningFactor) {
        if (waitAtBeginningFactor > 0.0) {
            this.waitAtBeginningFactor = waitAtBeginningFactor;
        }
    }

    public Set<FeedScopedId> getBannedRoutes(Collection<Route> routes) {
        if (this.bannedRoutes.isEmpty() && this.bannedAgencies.isEmpty() && this.whiteListedRoutes.isEmpty() && this.whiteListedAgencies.isEmpty()) {
            return Set.of();
        }
        HashSet<FeedScopedId> bannedRoutes = new HashSet<FeedScopedId>();
        for (Route route : routes) {
            if (!this.routeIsBanned(route)) continue;
            bannedRoutes.add(route.getId());
        }
        return bannedRoutes;
    }

    public double getMaxAccessEgressDurationSecondsForMode(StreetMode mode) {
        return this.maxAccessEgressDurationSecondsForMode.getOrDefault((Object)mode, this.maxAccessEgressDurationSeconds);
    }

    private boolean routeIsBanned(Route route) {
        if (!this.bannedAgencies.isEmpty() && this.bannedAgencies.contains(route.getAgency().getId())) {
            return true;
        }
        if (!this.bannedRoutes.isEmpty() && this.bannedRoutes.matches(route)) {
            return true;
        }
        boolean whiteListed = false;
        boolean whiteListInUse = false;
        if (!this.whiteListedAgencies.isEmpty()) {
            whiteListInUse = true;
            if (this.whiteListedAgencies.contains(route.getAgency().getId())) {
                whiteListed = true;
            }
        }
        if (!this.whiteListedRoutes.isEmpty()) {
            whiteListInUse = true;
            if (this.whiteListedRoutes.matches(route)) {
                whiteListed = true;
            }
        }
        return whiteListInUse && !whiteListed;
    }

    public long preferencesPenaltyForRoute(Route route) {
        long preferences_penalty = 0L;
        FeedScopedId agencyID = route.getAgency().getId();
        if (!this.preferredRoutes.equals(RouteMatcher.emptyMatcher()) || !this.preferredAgencies.isEmpty()) {
            boolean isPreferedRoute = this.preferredRoutes.matches(route);
            boolean isPreferedAgency = this.preferredAgencies.contains(agencyID);
            if (!isPreferedRoute && !isPreferedAgency) {
                preferences_penalty += (long)this.otherThanPreferredRoutesPenalty;
            }
        }
        boolean isUnpreferedRoute = this.unpreferredRoutes.matches(route);
        boolean isUnpreferedAgency = this.unpreferredAgencies.contains(agencyID);
        if (isUnpreferedRoute || isUnpreferedAgency) {
            preferences_penalty += (long)this.useUnpreferredRoutesPenalty;
        }
        return preferences_penalty;
    }

    public void setTriangleNormalized(double safe, double slope, double time) {
        double total;
        if (safe == 0.0 && slope == 0.0 && time == 0.0) {
            float oneThird = 0.33333334f;
            safe = oneThird;
            slope = oneThird;
            time = oneThird;
        }
        if ((total = (safe = this.setMinValue(safe)) + (slope = this.setMinValue(slope)) + (time = this.setMinValue(time))) != 1.0) {
            LOG.warn("Bicycle triangle factors don't add up to 1. Values will be scaled proportionally to each other.");
        }
        this.bikeTriangleSafetyFactor = safe /= total;
        this.bikeTriangleSlopeFactor = slope /= total;
        this.bikeTriangleTimeFactor = time /= total;
    }

    private double setMinValue(double value) {
        return Math.max(0.0, value);
    }

    public ShortestPathTree getNewShortestPathTree() {
        return this.dominanceFunction.getNewShortestPathTree(this);
    }

    public Comparator<GraphPath> getPathComparator(boolean compareStartTimes) {
        if ("duration".equals(this.pathComparator)) {
            return new DurationComparator();
        }
        return new PathComparator(compareStartTimes);
    }

    public boolean isCloseToStartOrEnd(Vertex vertex) {
        if (this.from == null || this.to == null || this.from.getCoordinate() == null || this.to.getCoordinate() == null) {
            return false;
        }
        if (this.fromEnvelope == null) {
            this.fromEnvelope = RoutingRequest.getEnvelope(this.from.getCoordinate(), 500);
        }
        if (this.toEnvelope == null) {
            this.toEnvelope = RoutingRequest.getEnvelope(this.to.getCoordinate(), 500);
        }
        return this.fromEnvelope.intersects(vertex.getCoordinate()) || this.toEnvelope.intersects(vertex.getCoordinate());
    }

    private static Envelope getEnvelope(Coordinate c, int meters) {
        double lat = SphericalDistanceLibrary.metersToDegrees(meters);
        double lon = SphericalDistanceLibrary.metersToLonDegrees(meters, c.y);
        Envelope env = new Envelope(c);
        env.expandBy(lon, lat);
        if (LOG.isDebugEnabled()) {
            Geometry geom = new GeometryFactory().toGeometry(env);
            GeometryJSON geoJson = new GeometryJSON();
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                geoJson.write(geom, (OutputStream)stream);
                LOG.debug("Computing {}m envelope around coordinate {}. GeoJSON: {}", new Object[]{meters, c, stream.toString()});
            }
            catch (IOException e) {
                LOG.error("Could not build debug GeoJSON", (Throwable)e);
            }
        }
        return env;
    }

    public IntersectionTraversalCostModel getIntersectionTraversalCostModel() {
        if (this.rctx != null && this.rctx.graph != null) {
            return this.rctx.graph.getIntersectionTraversalModel();
        }
        return Graph.DEFAULT_INTERSECTION_TRAVERSAL_COST_MODEL;
    }
}

