/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opentripplanner.model.modes.AllowedTransitMode;
import org.opentripplanner.routing.api.request.StreetMode;

public class RequestModes {
    @Nonnull
    public StreetMode accessMode;
    @Nonnull
    public StreetMode transferMode;
    @Nonnull
    public StreetMode egressMode;
    @Nonnull
    public StreetMode directMode;
    @Nonnull
    public Set<AllowedTransitMode> transitModes;
    public static RequestModes defaultRequestModes = new RequestModes(StreetMode.WALK, StreetMode.WALK, StreetMode.WALK, StreetMode.WALK, new HashSet<AllowedTransitMode>(AllowedTransitMode.getAllTransitModes()));

    public RequestModes(StreetMode accessMode, StreetMode transferMode, StreetMode egressMode, StreetMode directMode, Collection<AllowedTransitMode> transitModes) {
        this.accessMode = accessMode != null && accessMode.access ? accessMode : StreetMode.NOT_SET;
        this.transferMode = transferMode != null && transferMode.transfer ? transferMode : StreetMode.NOT_SET;
        this.egressMode = egressMode != null && egressMode.egress ? egressMode : StreetMode.NOT_SET;
        this.directMode = directMode != null ? directMode : StreetMode.NOT_SET;
        this.transitModes = transitModes != null ? new HashSet<AllowedTransitMode>(transitModes) : Set.of();
    }

    public boolean contains(StreetMode streetMode) {
        return streetMode.equals((Object)this.accessMode) || streetMode.equals((Object)this.egressMode) || streetMode.equals((Object)this.directMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestModes that = (RequestModes)o;
        if (this.accessMode != that.accessMode) {
            return false;
        }
        if (this.egressMode != that.egressMode) {
            return false;
        }
        if (this.directMode != that.directMode) {
            return false;
        }
        return this.transitModes.equals(that.transitModes);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("accessMode", (Object)this.accessMode).append("egressMode", (Object)this.egressMode).append("directMode", (Object)this.directMode).append("transitModes", this.transitModes).toString();
    }
}

