/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.io.Serializable;
import java.util.function.DoubleFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestFunctions {
    private static final String SEP = "\\s*";
    private static final String NUM = "([\\d.,]+)";
    public static final String PLUS = Pattern.quote("+");
    private static final Pattern LINEAR_FUNCTION_PATTERN = Pattern.compile("([\\d.,]+)\\s*" + PLUS + "\\s*([\\d.,]+)\\s*[Xx]");

    private RequestFunctions() {
    }

    public static DoubleFunction<Double> parse(String text) {
        if (text == null || text.isBlank()) {
            return null;
        }
        Matcher m = LINEAR_FUNCTION_PATTERN.matcher(text);
        if (m.find()) {
            return RequestFunctions.createLinearFunction(Double.parseDouble(m.group(1)), Double.parseDouble(m.group(2)));
        }
        throw new IllegalArgumentException("Unable to parse function: '" + text + "'");
    }

    public static DoubleFunction<Double> createLinearFunction(double constant, double coefficient) {
        return new LinearFunction(constant, coefficient);
    }

    public static String serialize(Object function) {
        if (function == null) {
            return null;
        }
        if (function instanceof LinearFunction) {
            return ((LinearFunction)function).serialize();
        }
        throw new IllegalArgumentException("Function type is not valid: " + function.getClass());
    }

    private static class LinearFunction
    implements DoubleFunction<Double>,
    Serializable {
        private final double a;
        private final double b;

        public LinearFunction(double constant, double coefficient) {
            this.a = constant;
            this.b = coefficient;
        }

        public double calculate(double x) {
            return this.a + this.b * x;
        }

        @Override
        public Double apply(double value) {
            return this.calculate(value);
        }

        public String toString() {
            return "f(x) = " + this.a + " + " + this.b + " x";
        }

        String serialize() {
            return this.a + " + " + this.b + " x";
        }
    }
}

