/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.api.request;

import java.util.function.DoubleFunction;
import org.opentripplanner.routing.api.request.RequestFunctions;

public class ItineraryFilterParameters {
    public boolean debug;
    public double groupSimilarityKeepOne;
    public double groupSimilarityKeepThree;
    public double groupedOtherThanSameLegsMaxCostMultiplier;
    public DoubleFunction<Double> transitGeneralizedCostLimit;
    public double bikeRentalDistanceRatio;
    public double parkAndRideDurationRatio;
    public DoubleFunction<Double> nonTransitGeneralizedCostLimit;

    private ItineraryFilterParameters() {
        this.debug = false;
        this.groupSimilarityKeepOne = 0.85;
        this.groupSimilarityKeepThree = 0.68;
        this.groupedOtherThanSameLegsMaxCostMultiplier = 2.0;
        this.bikeRentalDistanceRatio = 0.0;
        this.parkAndRideDurationRatio = 0.0;
        this.transitGeneralizedCostLimit = RequestFunctions.createLinearFunction(3600.0, 2.0);
        this.nonTransitGeneralizedCostLimit = RequestFunctions.createLinearFunction(3600.0, 2.0);
    }

    public static ItineraryFilterParameters createDefault() {
        return new ItineraryFilterParameters();
    }

    public ItineraryFilterParameters(boolean debug, double groupSimilarityKeepOne, double groupSimilarityKeepThree, double groupedOtherThanSameLegsMaxCostMultiplier, DoubleFunction<Double> transitGeneralizedCostLimit, DoubleFunction<Double> nonTransitGeneralizedCostLimit, double bikeRentalDistanceRatio, double parkAndRideDurationRatio) {
        this.debug = debug;
        this.groupSimilarityKeepOne = groupSimilarityKeepOne;
        this.groupSimilarityKeepThree = groupSimilarityKeepThree;
        this.groupedOtherThanSameLegsMaxCostMultiplier = groupedOtherThanSameLegsMaxCostMultiplier;
        this.transitGeneralizedCostLimit = transitGeneralizedCostLimit;
        this.nonTransitGeneralizedCostLimit = nonTransitGeneralizedCostLimit;
        this.bikeRentalDistanceRatio = bikeRentalDistanceRatio;
        this.parkAndRideDurationRatio = parkAndRideDurationRatio;
    }
}

