/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model;

import java.util.Objects;
import org.opentripplanner.model.base.ValueObjectToStringBuilder;
import org.opentripplanner.routing.algorithm.transferoptimization.model.StopTime;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;

public final class TripStopTime<T extends RaptorTripSchedule>
implements StopTime {
    private final T trip;
    private final int stopPosition;
    private final boolean departure;

    private TripStopTime(T trip, int stopPosition, boolean departure) {
        this.assertStopPositionIsInRange(stopPosition, trip);
        this.trip = trip;
        this.stopPosition = stopPosition;
        this.departure = departure;
    }

    public static <T extends RaptorTripSchedule> TripStopTime<T> arrival(T trip, int stopPosition) {
        return new TripStopTime<T>(trip, stopPosition, false);
    }

    public static <T extends RaptorTripSchedule> TripStopTime<T> arrival(T trip, StopTime stopTime) {
        int stopPosition = trip.findArrivalStopPosition(stopTime.time(), stopTime.stop());
        return TripStopTime.arrival(trip, stopPosition);
    }

    public static <T extends RaptorTripSchedule> TripStopTime<T> departure(T trip, int stopPosition) {
        return new TripStopTime<T>(trip, stopPosition, true);
    }

    public static <T extends RaptorTripSchedule> TripStopTime<T> departure(T trip, StopTime stopTime) {
        int stopPosition = trip.findDepartureStopPosition(stopTime.time(), stopTime.stop());
        return TripStopTime.departure(trip, stopPosition);
    }

    public T trip() {
        return this.trip;
    }

    public int stopPosition() {
        return this.stopPosition;
    }

    @Override
    public int stop() {
        return this.trip.pattern().stopIndex(this.stopPosition);
    }

    @Override
    public int time() {
        return this.departure ? this.trip.departure(this.stopPosition) : this.trip.arrival(this.stopPosition);
    }

    public String toString() {
        return ValueObjectToStringBuilder.of().addText("[").addNum(this.stop()).addText(" ").addServiceTime(this.time()).addText(" ").addObj(this.trip.pattern().debugInfo()).addText("]").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripStopTime that = (TripStopTime)o;
        return this.stopPosition == that.stopPosition && this.departure == that.departure && this.trip.equals(that.trip);
    }

    public int hashCode() {
        return Objects.hash(this.trip, this.stopPosition, this.departure);
    }

    private void assertStopPositionIsInRange(int stopPosition, T trip) {
        if (stopPosition < 0 || stopPosition >= trip.pattern().numberOfStopsInPattern()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

