/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;

public class MinCostFilterChain<T> {
    private final List<ToIntFunction<T>> costFunctions;

    public MinCostFilterChain(List<ToIntFunction<T>> costFunctions) {
        this.costFunctions = costFunctions;
    }

    public Set<T> filter(Set<T> elements) {
        for (ToIntFunction<T> costFunction : this.costFunctions) {
            elements = this.filter(elements, costFunction);
        }
        return elements;
    }

    private Set<T> filter(Set<T> elements, ToIntFunction<T> costFunction) {
        HashSet<T> result = new HashSet<T>();
        int minCost = Integer.MAX_VALUE;
        for (T it : elements) {
            int cost = costFunction.applyAsInt(it);
            if (cost == minCost) {
                result.add(it);
                continue;
            }
            if (cost >= minCost) continue;
            minCost = cost;
            result.clear();
            result.add(it);
        }
        return result;
    }
}

