/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.transferoptimization.api;

import java.util.function.Supplier;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.routing.algorithm.transferoptimization.api.TransferOptimized;
import org.opentripplanner.transit.raptor.api.path.AccessPathLeg;
import org.opentripplanner.transit.raptor.api.path.Path;
import org.opentripplanner.transit.raptor.api.path.PathLeg;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripSchedule;
import org.opentripplanner.transit.raptor.util.PathStringBuilder;

public class OptimizedPath<T extends RaptorTripSchedule>
extends Path<T>
implements TransferOptimized {
    private final int transferPriorityCost;
    private final int waitTimeOptimizedCost;
    private final int breakTieCost;

    public OptimizedPath(Path<T> originalPath) {
        this(originalPath.accessLeg(), originalPath.rangeRaptorIterationDepartureTime(), originalPath.generalizedCost(), OptimizedPath.priorityCost(originalPath), 0, 0);
    }

    public OptimizedPath(AccessPathLeg<T> accessPathLeg, int iterationStartTime, int generalizedCost, int transferPriorityCost, int waitTimeOptimizedCost, int breakTieCost) {
        super(iterationStartTime, accessPathLeg, generalizedCost);
        this.transferPriorityCost = transferPriorityCost;
        this.waitTimeOptimizedCost = waitTimeOptimizedCost;
        this.breakTieCost = breakTieCost;
    }

    @Override
    public int transferPriorityCost() {
        return this.transferPriorityCost;
    }

    public static int priorityCost(boolean transferExist, Supplier<RaptorConstrainedTransfer> txGet) {
        if (transferExist) {
            RaptorConstrainedTransfer tx = txGet.get();
            TransferConstraint c = tx == null ? null : (TransferConstraint)tx.getTransferConstraint();
            return TransferConstraint.cost(c);
        }
        return 0;
    }

    @Override
    public int generalizedCostWaitTimeOptimized() {
        return this.generalizedCost() + this.waitTimeOptimizedCost;
    }

    @Override
    public int breakTieCost() {
        return this.breakTieCost;
    }

    @Override
    public String toStringDetailed(RaptorStopNameResolver stopNameResolver) {
        return this.buildString(true, stopNameResolver, this::appendSummary);
    }

    @Override
    public String toString(RaptorStopNameResolver stopNameResolver) {
        return this.buildString(false, stopNameResolver, this::appendSummary);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    private void appendSummary(PathStringBuilder buf) {
        buf.costCentiSec(this.transferPriorityCost, 0, "pri");
        buf.costCentiSec(this.generalizedCostWaitTimeOptimized(), this.generalizedCost(), "wtc");
    }

    private static int priorityCost(Path<?> path) {
        return path.legStream().mapToInt(OptimizedPath::priorityCost).sum();
    }

    private static int priorityCost(PathLeg<?> leg) {
        return OptimizedPath.priorityCost(leg.isTransitLeg() && leg.nextTransitLeg() != null, () -> leg.asTransitLeg().getConstrainedTransferAfterLeg());
    }
}

