/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.time.LocalDate;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;

public final class TripScheduleWithOffset
implements TripSchedule {
    private final int secondsOffset;
    private final TripPatternForDates pattern;
    private final TripTimes tripTimes;
    private final LocalDate serviceDate;
    private final int sortIndex;
    private final int transitReluctanceIndex;

    TripScheduleWithOffset(TripPatternForDates pattern, LocalDate localDate, TripTimes tripTimes, int offset) {
        this.pattern = pattern;
        this.tripTimes = tripTimes;
        this.secondsOffset = offset;
        this.serviceDate = localDate;
        this.sortIndex = this.arrival(0);
        this.transitReluctanceIndex = pattern.getTripPattern().getPattern().getMode().ordinal();
    }

    @Override
    public int tripSortIndex() {
        return this.sortIndex;
    }

    @Override
    public int arrival(int stopPosInPattern) {
        return this.tripTimes.getArrivalTime(stopPosInPattern) + this.secondsOffset;
    }

    @Override
    public int departure(int stopPosInPattern) {
        return this.tripTimes.getDepartureTime(stopPosInPattern) + this.secondsOffset;
    }

    @Override
    public RaptorTripPattern pattern() {
        return this.pattern;
    }

    @Override
    public TripTimes getOriginalTripTimes() {
        return this.tripTimes;
    }

    @Override
    public TripPattern getOriginalTripPattern() {
        return this.pattern.getTripPattern().getPattern();
    }

    @Override
    public LocalDate getServiceDate() {
        return this.serviceDate;
    }

    @Override
    public int transitReluctanceFactorIndex() {
        return this.transitReluctanceIndex;
    }

    public String toString() {
        return ToStringBuilder.of(TripScheduleWithOffset.class).addObj("trip", this.pattern.debugInfo()).addServiceTime("depart", this.secondsOffset + this.tripTimes.getDepartureTime(0)).toString();
    }

    public int getSecondsOffset() {
        return this.secondsOffset;
    }
}

