/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.List;
import java.util.function.IntUnaryOperator;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternWithRaptorStopIndexes;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency.TripFrequencyAlightSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.frequency.TripFrequencyBoardSearch;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripScheduleWithOffset;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.opentripplanner.transit.raptor.api.request.SearchDirection;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTripScheduleBoardingSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorRoute;
import org.opentripplanner.transit.raptor.api.transit.RaptorTimeTable;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripPattern;
import org.opentripplanner.transit.raptor.api.transit.RaptorTripScheduleSearch;
import org.opentripplanner.transit.raptor.util.IntIterators;

public class TripPatternForDates
implements RaptorRoute<TripSchedule>,
RaptorTimeTable<TripSchedule>,
RaptorTripPattern {
    private final TripPatternWithRaptorStopIndexes tripPattern;
    private final TripPatternForDate[] tripPatternForDates;
    private final int[] offsets;
    private final int numberOfTripSchedules;
    private final boolean isFrequencyBased;
    private final int[] arrivalTimes;
    private final int[] departureTimes;

    TripPatternForDates(TripPatternWithRaptorStopIndexes tripPattern, List<TripPatternForDate> tripPatternForDates, List<Integer> offsets) {
        this.tripPattern = tripPattern;
        this.tripPatternForDates = tripPatternForDates.toArray(new TripPatternForDate[0]);
        this.offsets = offsets.stream().mapToInt(i -> i).toArray();
        int numberOfTripSchedules = 0;
        boolean hasFrequencies = false;
        for (TripPatternForDate tripPatternForDate : tripPatternForDates) {
            numberOfTripSchedules += tripPatternForDate.numberOfTripSchedules();
            if (!tripPatternForDate.hasFrequencies()) continue;
            hasFrequencies = true;
        }
        this.numberOfTripSchedules = numberOfTripSchedules;
        this.isFrequencyBased = hasFrequencies;
        int nStops = tripPattern.getStopIndexes().length;
        this.arrivalTimes = new int[nStops * numberOfTripSchedules];
        this.departureTimes = new int[nStops * numberOfTripSchedules];
        int i2 = 0;
        for (int d = 0; d < tripPatternForDates.size(); ++d) {
            int offset = this.offsets[d];
            for (TripTimes trip : tripPatternForDates.get(d).tripTimes()) {
                for (int s = 0; s < nStops; ++s) {
                    this.arrivalTimes[s * numberOfTripSchedules + i2] = trip.getArrivalTime(s) + offset;
                    this.departureTimes[s * numberOfTripSchedules + i2] = trip.getDepartureTime(s) + offset;
                }
                ++i2;
            }
        }
    }

    public TripPatternWithRaptorStopIndexes getTripPattern() {
        return this.tripPattern;
    }

    public IntIterator tripPatternForDatesIndexIterator(boolean ascendingOnDate) {
        return ascendingOnDate ? IntIterators.intIncIterator(0, this.tripPatternForDates.length) : IntIterators.intDecIterator(this.tripPatternForDates.length, 0);
    }

    public TripPatternForDate tripPatternForDate(int index) {
        return this.tripPatternForDates[index];
    }

    @Deprecated
    public int tripPatternForDateOffsets(int index) {
        return this.offsets[index];
    }

    @Override
    public RaptorTimeTable<TripSchedule> timetable() {
        return this;
    }

    @Override
    public RaptorTripPattern pattern() {
        return this;
    }

    @Override
    public RaptorConstrainedTripScheduleBoardingSearch<TripSchedule> transferConstraintsForwardSearch() {
        return this.getTripPattern().constrainedTransferForwardSearch();
    }

    @Override
    public RaptorConstrainedTripScheduleBoardingSearch<TripSchedule> transferConstraintsReverseSearch() {
        return this.getTripPattern().constrainedTransferReverseSearch();
    }

    @Override
    public int stopIndex(int stopPositionInPattern) {
        return this.tripPattern.stopIndex(stopPositionInPattern);
    }

    @Override
    public boolean boardingPossibleAt(int stopPositionInPattern) {
        return this.tripPattern.getPattern().canBoard(stopPositionInPattern);
    }

    @Override
    public boolean alightingPossibleAt(int stopPositionInPattern) {
        return this.tripPattern.getPattern().canAlight(stopPositionInPattern);
    }

    @Override
    public int numberOfStopsInPattern() {
        return this.tripPattern.getStopIndexes().length;
    }

    @Override
    public String debugInfo() {
        return this.tripPattern.getTransitMode().name() + " " + this.tripPattern.getPattern().getRoute().getShortName();
    }

    @Override
    public TripSchedule getTripSchedule(int index) {
        for (int i = 0; i < this.tripPatternForDates.length; ++i) {
            TripPatternForDate tripPatternForDate = this.tripPatternForDates[i];
            if (index < tripPatternForDate.numberOfTripSchedules()) {
                return new TripScheduleWithOffset(this, tripPatternForDate.getLocalDate(), tripPatternForDate.getTripTimes(index), this.offsets[i]);
            }
            index -= tripPatternForDate.numberOfTripSchedules();
        }
        throw new IndexOutOfBoundsException("Index out of bound: " + index);
    }

    @Override
    public IntUnaryOperator getArrivalTimes(int stopPositionInPattern) {
        int base = stopPositionInPattern * this.numberOfTripSchedules;
        return i -> this.arrivalTimes[base + i];
    }

    @Override
    public IntUnaryOperator getDepartureTimes(int stopPositionInPattern) {
        int base = stopPositionInPattern * this.numberOfTripSchedules;
        return i -> this.departureTimes[base + i];
    }

    @Override
    public int numberOfTripSchedules() {
        return this.numberOfTripSchedules;
    }

    @Override
    public boolean useCustomizedTripSearch() {
        return this.isFrequencyBased;
    }

    @Override
    public RaptorTripScheduleSearch<TripSchedule> createCustomizedTripSearch(SearchDirection direction) {
        return direction.isForward() ? new TripFrequencyBoardSearch(this) : new TripFrequencyAlightSearch<TripSchedule>(this);
    }

    public String toString() {
        return ToStringBuilder.of(TripPatternForDates.class).addObj("pattern", this.debugInfo()).addServiceTimeSchedule("offsets", this.offsets).addNum("nTrips", this.numberOfTripSchedules).toString();
    }
}

