/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.opentripplanner.model.BikeAccess;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.modes.AllowedTransitMode;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.graph.GraphIndex;
import org.opentripplanner.routing.trippattern.TripTimes;

public class RoutingRequestTransitDataProviderFilter
implements TransitDataProviderFilter {
    private final boolean requireBikesAllowed;
    private final boolean requireWheelchairAccessible;
    private final boolean includePlannedCancellations;
    private final Predicate<Trip> transitModeIsAllowed;
    private final Set<FeedScopedId> bannedRoutes;

    public RoutingRequestTransitDataProviderFilter(boolean requireBikesAllowed, boolean requireWheelchairAccessible, boolean includePlannedCancellations, Set<AllowedTransitMode> allowedTransitModes, Set<FeedScopedId> bannedRoutes) {
        this.requireBikesAllowed = requireBikesAllowed;
        this.requireWheelchairAccessible = requireWheelchairAccessible;
        this.includePlannedCancellations = includePlannedCancellations;
        this.bannedRoutes = bannedRoutes;
        boolean hasOnlyMainModeFilters = allowedTransitModes.stream().noneMatch(AllowedTransitMode::hasSubMode);
        if (hasOnlyMainModeFilters) {
            EnumSet allowedMainModes = allowedTransitModes.stream().map(AllowedTransitMode::getMainMode).collect(Collectors.toCollection(() -> EnumSet.noneOf(TransitMode.class)));
            this.transitModeIsAllowed = trip -> allowedMainModes.contains((Object)trip.getMode());
        } else {
            this.transitModeIsAllowed = trip -> {
                TransitMode transitMode = trip.getMode();
                String netexSubmode = trip.getNetexSubmode();
                return allowedTransitModes.stream().anyMatch(m -> m.allows(transitMode, netexSubmode));
            };
        }
    }

    public RoutingRequestTransitDataProviderFilter(RoutingRequest request, GraphIndex graphIndex) {
        this(request.modes.transferMode == StreetMode.BIKE, request.wheelchairAccessible, request.includePlannedCancellations, request.modes.transitModes, request.getBannedRoutes(graphIndex.getAllRoutes()));
    }

    @Override
    public boolean tripPatternPredicate(TripPatternForDate tripPatternForDate) {
        return this.routeIsNotBanned(tripPatternForDate);
    }

    @Override
    public boolean tripTimesPredicate(TripTimes tripTimes) {
        if (!this.transitModeIsAllowed.test(tripTimes.getTrip())) {
            return false;
        }
        if (this.requireBikesAllowed) {
            return RoutingRequestTransitDataProviderFilter.bikeAccessForTrip(tripTimes.getTrip()) == BikeAccess.ALLOWED;
        }
        if (this.requireWheelchairAccessible) {
            return tripTimes.getTrip().getWheelchairAccessible() == 1;
        }
        if (!this.includePlannedCancellations) {
            return !tripTimes.getTrip().getTripAlteration().isCanceledOrReplaced();
        }
        return true;
    }

    private boolean routeIsNotBanned(TripPatternForDate tripPatternForDate) {
        FeedScopedId routeId = tripPatternForDate.getTripPattern().getPattern().getRoute().getId();
        return !this.bannedRoutes.contains(routeId);
    }

    public static BikeAccess bikeAccessForTrip(Trip trip) {
        if (trip.getBikesAllowed() != BikeAccess.UNKNOWN) {
            return trip.getBikesAllowed();
        }
        return trip.getRoute().getBikesAllowed();
    }
}

