/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternWithRaptorStopIndexes;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.DateMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;

class RaptorRoutingRequestTransitDataCreator {
    private final TransitLayer transitLayer;
    private final ZonedDateTime transitSearchTimeZero;
    private final LocalDate departureDate;

    RaptorRoutingRequestTransitDataCreator(TransitLayer transitLayer, ZonedDateTime transitSearchTimeZero) {
        this.transitLayer = transitLayer;
        this.departureDate = transitSearchTimeZero.toLocalDate();
        this.transitSearchTimeZero = transitSearchTimeZero;
    }

    List<List<TripPatternForDates>> createTripPatternsPerStop(int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter) {
        List<TripPatternForDate> tripPatternForDates = this.getTripPatternsForDateRange(additionalPastSearchDays, additionalFutureSearchDays, filter);
        List<TripPatternForDates> tripPatternForDateList = RaptorRoutingRequestTransitDataCreator.merge(this.transitSearchTimeZero, tripPatternForDates);
        return RaptorRoutingRequestTransitDataCreator.createTripPatternsPerStop(tripPatternForDateList, this.transitLayer.getStopCount());
    }

    private List<TripPatternForDate> getTripPatternsForDateRange(int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter) {
        ArrayList<TripPatternForDate> tripPatternForDates = new ArrayList<TripPatternForDate>();
        for (int d = -additionalPastSearchDays; d <= additionalFutureSearchDays; ++d) {
            tripPatternForDates.addAll(RaptorRoutingRequestTransitDataCreator.filterActiveTripPatterns(this.transitLayer, this.departureDate.plusDays(d), d == 0, filter));
        }
        return tripPatternForDates;
    }

    static List<TripPatternForDates> merge(ZonedDateTime transitSearchTimeZero, List<TripPatternForDate> patternForDateList) {
        Map<TripPatternWithRaptorStopIndexes, List<TripPatternForDate>> patternForDateByPattern = patternForDateList.stream().collect(Collectors.groupingBy(TripPatternForDate::getTripPattern));
        ArrayList<TripPatternForDates> combinedList = new ArrayList<TripPatternForDates>();
        for (Map.Entry<TripPatternWithRaptorStopIndexes, List<TripPatternForDate>> patternEntry : patternForDateByPattern.entrySet()) {
            List<TripPatternForDate> patternsSorted = patternEntry.getValue().stream().sorted(Comparator.comparing(TripPatternForDate::getLocalDate)).collect(Collectors.toUnmodifiableList());
            ArrayList<Integer> offsets = new ArrayList<Integer>();
            for (TripPatternForDate tripPatternForDate : patternsSorted) {
                offsets.add(DateMapper.secondsSinceStartOfTime(transitSearchTimeZero, tripPatternForDate.getLocalDate()));
            }
            combinedList.add(new TripPatternForDates(patternEntry.getKey(), patternsSorted, offsets));
        }
        return combinedList;
    }

    private static List<List<TripPatternForDates>> createTripPatternsPerStop(List<TripPatternForDates> tripPatternsForDate, int numberOfStops) {
        List<List<TripPatternForDates>> result = Stream.generate(ArrayList::new).limit(numberOfStops).collect(Collectors.toList());
        for (TripPatternForDates tripPatternForDateList : tripPatternsForDate) {
            for (int i : tripPatternForDateList.getTripPattern().getStopIndexes()) {
                result.get(i).add(tripPatternForDateList);
            }
        }
        return result;
    }

    private static List<TripPatternForDate> filterActiveTripPatterns(TransitLayer transitLayer, LocalDate date, boolean firstDay, TransitDataProviderFilter filter) {
        return transitLayer.getTripPatternsForDate(date).stream().filter(filter::tripPatternPredicate).filter(p -> firstDay || p.getStartOfRunningPeriod().toLocalDate().equals(date)).map(p -> p.newWithFilteredTripTimes(filter::tripTimesPredicate)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

