/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.DefaultCostCalculator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.DateMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.McCostParamsMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRoutingRequestTransitDataCreator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TransitDataProviderFilter;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.TripPatternForDates;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.transit.raptor.api.transit.CostCalculator;
import org.opentripplanner.transit.raptor.api.transit.IntIterator;
import org.opentripplanner.transit.raptor.api.transit.RaptorConstrainedTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorPathConstrainedTransferSearch;
import org.opentripplanner.transit.raptor.api.transit.RaptorRoute;
import org.opentripplanner.transit.raptor.api.transit.RaptorStopNameResolver;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransitDataProvider;
import org.opentripplanner.util.OTPFeature;

public class RaptorRoutingRequestTransitData
implements RaptorTransitDataProvider<TripSchedule> {
    private final TransitLayer transitLayer;
    private final TransferService transferService;
    private final List<List<TripPatternForDates>> activeTripPatternsPerStop;
    private final RaptorTransferIndex transfers;
    private final ZonedDateTime transitSearchTimeZero;
    private final CostCalculator generalizedCostCalculator;
    private final int validTransitDataStartTime;
    private final int validTransitDataEndTime;

    public RaptorRoutingRequestTransitData(TransferService transferService, TransitLayer transitLayer, ZonedDateTime transitSearchTimeZero, int additionalPastSearchDays, int additionalFutureSearchDays, TransitDataProviderFilter filter, RoutingRequest routingRequest) {
        this.transferService = transferService;
        this.transitLayer = transitLayer;
        this.transitSearchTimeZero = transitSearchTimeZero;
        RaptorRoutingRequestTransitDataCreator transitDataCreator = new RaptorRoutingRequestTransitDataCreator(transitLayer, transitSearchTimeZero);
        this.activeTripPatternsPerStop = transitDataCreator.createTripPatternsPerStop(additionalPastSearchDays, additionalFutureSearchDays, filter);
        this.transfers = transitLayer.getRaptorTransfersForRequest(routingRequest);
        this.generalizedCostCalculator = new DefaultCostCalculator(McCostParamsMapper.map(routingRequest), transitLayer.getStopIndex().stopBoardAlightCosts);
        this.validTransitDataStartTime = DateMapper.secondsSinceStartOfTime(this.transitSearchTimeZero, this.transitSearchTimeZero.minusDays(additionalPastSearchDays).toInstant());
        this.validTransitDataEndTime = DateMapper.secondsSinceStartOfTime(this.transitSearchTimeZero, this.transitSearchTimeZero.plusDays(additionalFutureSearchDays + 1).toInstant());
    }

    @Override
    public Iterator<RaptorTransfer> getTransfersFromStop(int stopIndex) {
        return this.transfers.getForwardTransfers().get(stopIndex).iterator();
    }

    @Override
    public Iterator<? extends RaptorTransfer> getTransfersToStop(int stopIndex) {
        return this.transfers.getReversedTransfers().get(stopIndex).iterator();
    }

    @Override
    public Iterator<? extends RaptorRoute<TripSchedule>> routeIterator(IntIterator stops) {
        LinkedHashSet activeTripPatternsForGivenStops = new LinkedHashSet();
        while (stops.hasNext()) {
            activeTripPatternsForGivenStops.addAll(this.activeTripPatternsPerStop.get(stops.next()));
        }
        return activeTripPatternsForGivenStops.iterator();
    }

    @Override
    public int numberOfStops() {
        return this.transitLayer.getStopCount();
    }

    @Override
    public CostCalculator multiCriteriaCostCalculator() {
        return this.generalizedCostCalculator;
    }

    @Override
    public RaptorPathConstrainedTransferSearch<TripSchedule> transferConstraintsSearch() {
        if (OTPFeature.TransferConstraints.isOff() || this.transferService == null) {
            return null;
        }
        return new RaptorPathConstrainedTransferSearch<TripSchedule>(){

            @Override
            @Nullable
            public RaptorConstrainedTransfer findConstrainedTransfer(TripSchedule fromTrip, int fromStopPosition, TripSchedule toTrip, int toStopPosition) {
                return RaptorRoutingRequestTransitData.this.transferService.findTransfer(fromTrip.getOriginalTripTimes().getTrip(), fromStopPosition, RaptorRoutingRequestTransitData.this.transitLayer.getStopByIndex(fromTrip.pattern().stopIndex(fromStopPosition)), toTrip.getOriginalTripTimes().getTrip(), toStopPosition, RaptorRoutingRequestTransitData.this.transitLayer.getStopByIndex(toTrip.pattern().stopIndex(toStopPosition)));
            }
        };
    }

    @Override
    public RaptorStopNameResolver stopNameResolver() {
        return stopIndex -> {
            StopLocation s = this.transitLayer.getStopByIndex(stopIndex);
            return s == null ? "null" : s.getName() + "(" + stopIndex + ")";
        };
    }

    @Override
    public int getValidTransitDataStartTime() {
        return this.validTransitDataStartTime;
    }

    @Override
    public int getValidTransitDataEndTime() {
        return this.validTransitDataEndTime;
    }
}

