/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.request;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.RaptorTransferIndex;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.core.BicycleOptimizeType;

public class RaptorRequestTransferCache {
    private final LoadingCache<CacheKey, RaptorTransferIndex> transferCache;

    public RaptorRequestTransferCache(int maximumSize) {
        this.transferCache = CacheBuilder.newBuilder().maximumSize((long)maximumSize).build(this.cacheLoader());
    }

    public LoadingCache<CacheKey, RaptorTransferIndex> getTransferCache() {
        return this.transferCache;
    }

    public RaptorTransferIndex get(List<List<Transfer>> transfersByStopIndex, RoutingRequest routingRequest) {
        try {
            return (RaptorTransferIndex)this.transferCache.get((Object)new CacheKey(transfersByStopIndex, routingRequest));
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to get item from transfer cache", e);
        }
    }

    private CacheLoader<CacheKey, RaptorTransferIndex> cacheLoader() {
        return new CacheLoader<CacheKey, RaptorTransferIndex>(){

            public RaptorTransferIndex load(@Nonnull CacheKey cacheKey) {
                return RaptorTransferIndex.create(cacheKey.transfersByStopIndex, cacheKey.routingRequest);
            }
        };
    }

    private static class StreetRelevantOptions {
        private final StreetMode transferMode;
        private final BicycleOptimizeType optimize;
        private final double bikeTriangleSafetyFactor;
        private final double bikeTriangleSlopeFactor;
        private final double bikeTriangleTimeFactor;
        private final boolean wheelchairAccessible;
        private final double maxWheelchairSlope;
        private final double walkSpeed;
        private final double bikeSpeed;
        private final double walkReluctance;
        private final double stairsReluctance;
        private final double stairsTimeFactor;
        private final double turnReluctance;
        private final int elevatorBoardCost;
        private final int elevatorBoardTime;
        private final int elevatorHopCost;
        private final int elevatorHopTime;
        private final int bikeSwitchCost;
        private final int bikeSwitchTime;

        public StreetRelevantOptions(RoutingRequest routingRequest) {
            this.transferMode = routingRequest.modes.transferMode;
            this.optimize = routingRequest.bicycleOptimizeType;
            this.bikeTriangleSafetyFactor = routingRequest.bikeTriangleSafetyFactor;
            this.bikeTriangleSlopeFactor = routingRequest.bikeTriangleSlopeFactor;
            this.bikeTriangleTimeFactor = routingRequest.bikeTriangleTimeFactor;
            this.bikeSwitchCost = routingRequest.bikeSwitchCost;
            this.bikeSwitchTime = routingRequest.bikeSwitchTime;
            this.wheelchairAccessible = routingRequest.wheelchairAccessible;
            this.maxWheelchairSlope = routingRequest.maxWheelchairSlope;
            this.walkSpeed = routingRequest.walkSpeed;
            this.bikeSpeed = routingRequest.bikeSpeed;
            this.walkReluctance = routingRequest.walkReluctance;
            this.stairsReluctance = routingRequest.stairsReluctance;
            this.stairsTimeFactor = routingRequest.stairsTimeFactor;
            this.turnReluctance = routingRequest.turnReluctance;
            this.elevatorBoardCost = routingRequest.elevatorBoardCost;
            this.elevatorBoardTime = routingRequest.elevatorBoardTime;
            this.elevatorHopCost = routingRequest.elevatorHopCost;
            this.elevatorHopTime = routingRequest.elevatorHopTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreetRelevantOptions that = (StreetRelevantOptions)o;
            return Double.compare(that.bikeTriangleSafetyFactor, this.bikeTriangleSafetyFactor) == 0 && Double.compare(that.bikeTriangleSlopeFactor, this.bikeTriangleSlopeFactor) == 0 && Double.compare(that.bikeTriangleTimeFactor, this.bikeTriangleTimeFactor) == 0 && Double.compare(that.maxWheelchairSlope, this.maxWheelchairSlope) == 0 && Double.compare(that.walkSpeed, this.walkSpeed) == 0 && Double.compare(that.bikeSpeed, this.bikeSpeed) == 0 && Double.compare(that.walkReluctance, this.walkReluctance) == 0 && Double.compare(that.stairsReluctance, this.stairsReluctance) == 0 && Double.compare(that.stairsTimeFactor, this.stairsTimeFactor) == 0 && Double.compare(that.turnReluctance, this.turnReluctance) == 0 && this.wheelchairAccessible == that.wheelchairAccessible && this.elevatorBoardCost == that.elevatorBoardCost && this.elevatorBoardTime == that.elevatorBoardTime && this.elevatorHopCost == that.elevatorHopCost && this.elevatorHopTime == that.elevatorHopTime && this.bikeSwitchCost == that.bikeSwitchCost && this.bikeSwitchTime == that.bikeSwitchTime && this.transferMode == that.transferMode && this.optimize == that.optimize;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.transferMode, this.optimize, this.bikeTriangleSafetyFactor, this.bikeTriangleSlopeFactor, this.bikeTriangleTimeFactor, this.wheelchairAccessible, this.maxWheelchairSlope, this.walkSpeed, this.bikeSpeed, this.walkReluctance, this.stairsReluctance, this.turnReluctance, this.elevatorBoardCost, this.elevatorBoardTime, this.elevatorHopCost, this.elevatorHopTime, this.bikeSwitchCost, this.bikeSwitchTime, this.stairsTimeFactor});
        }
    }

    private static class CacheKey {
        private final List<List<Transfer>> transfersByStopIndex;
        private final RoutingRequest routingRequest;
        private final StreetRelevantOptions options;

        private CacheKey(List<List<Transfer>> transfersByStopIndex, RoutingRequest routingRequest) {
            this.transfersByStopIndex = transfersByStopIndex;
            this.routingRequest = routingRequest;
            this.options = new StreetRelevantOptions(routingRequest);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.transfersByStopIndex == cacheKey.transfersByStopIndex && this.options.equals(cacheKey.options);
        }

        public int hashCode() {
            return this.options.hashCode();
        }
    }
}

