/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import gnu.trove.set.TIntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternWithRaptorStopIndexes;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.ServiceCalendarMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerMapper;
import org.opentripplanner.routing.trippattern.FrequencyEntry;
import org.opentripplanner.routing.trippattern.RealTimeState;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripPatternForDateMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TripPatternForDateMapper.class);
    private final ConcurrentMap<Timetable, List<TripTimes>> sortedTripTimesForTimetable = new ConcurrentHashMap<Timetable, List<TripTimes>>();
    private final Map<ServiceDate, TIntSet> serviceCodesRunningForDate;
    private final Map<TripPattern, TripPatternWithRaptorStopIndexes> newTripPatternForOld;

    TripPatternForDateMapper(Map<ServiceDate, TIntSet> serviceCodesRunningForDate, Map<TripPattern, TripPatternWithRaptorStopIndexes> newTripPatternForOld) {
        this.serviceCodesRunningForDate = Collections.unmodifiableMap(serviceCodesRunningForDate);
        this.newTripPatternForOld = Collections.unmodifiableMap(newTripPatternForOld);
    }

    public TripPatternForDate map(Timetable timetable, ServiceDate serviceDate) {
        TIntSet serviceCodesRunning = this.serviceCodesRunningForDate.get(serviceDate);
        TripPattern oldTripPattern = timetable.getPattern();
        ArrayList<TripTimes> times = new ArrayList<TripTimes>();
        List sortedTripTimes = this.sortedTripTimesForTimetable.computeIfAbsent(timetable, TransitLayerMapper::getSortedTripTimes);
        for (TripTimes tripTimes : sortedTripTimes) {
            if (!serviceCodesRunning.contains(tripTimes.getServiceCode()) || tripTimes.getRealTimeState() == RealTimeState.CANCELED) continue;
            times.add(tripTimes);
        }
        List<FrequencyEntry> frequencies = timetable.getFrequencyEntries().stream().filter(frequency -> serviceCodesRunning.contains(frequency.tripTimes.getServiceCode())).sorted(Comparator.comparing(frequencyEntry -> frequencyEntry.startTime)).collect(Collectors.toList());
        if (times.isEmpty() && frequencies.isEmpty()) {
            if (timetable.getServiceDate() == serviceDate) {
                LOG.debug("Tried to update TripPattern {}, but no service codes are valid for date {}", (Object)timetable.getPattern().getId(), (Object)serviceDate);
            }
            return null;
        }
        return new TripPatternForDate(this.newTripPatternForOld.get(oldTripPattern), times, frequencies, ServiceCalendarMapper.localDateFromServiceDate(serviceDate));
    }
}

