/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import gnu.trove.set.TIntSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternWithRaptorStopIndexes;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferIndexGenerator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.ServiceCalendarMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TripPatternForDateMapper;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitLayerUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(TransitLayerUpdater.class);
    private final Graph graph;
    private final Map<ServiceDate, TIntSet> serviceCodesRunningForDate;
    private final Map<LocalDate, Map<TripPattern, TripPatternForDate>> tripPatternsStartingOnDateMapCache = new HashMap<LocalDate, Map<TripPattern, TripPatternForDate>>();
    private final Map<LocalDate, Set<TripPatternForDate>> tripPatternsRunningOnDateMapCache = new HashMap<LocalDate, Set<TripPatternForDate>>();

    public TransitLayerUpdater(Graph graph, Map<ServiceDate, TIntSet> serviceCodesRunningForDate) {
        this.graph = graph;
        this.serviceCodesRunningForDate = serviceCodesRunningForDate;
    }

    public void update(Set<Timetable> updatedTimetables) {
        if (!this.graph.hasRealtimeTransitLayer()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        TransitLayer realtimeTransitLayer = new TransitLayer(this.graph.getRealtimeTransitLayer());
        Map<TripPattern, TripPatternWithRaptorStopIndexes> newTripPatternForOld = realtimeTransitLayer.getTripPatternMapper().mapOldTripPatternToRaptorTripPattern(realtimeTransitLayer.getStopIndex(), updatedTimetables.stream().map(Timetable::getPattern).collect(Collectors.toSet()));
        TripPatternForDateMapper tripPatternForDateMapper = new TripPatternForDateMapper(this.serviceCodesRunningForDate, newTripPatternForOld);
        HashSet<LocalDate> datesToBeUpdated = new HashSet<LocalDate>();
        HashMap<TripPattern, TripPatternForDate> newTripPatternsForDate = new HashMap<TripPattern, TripPatternForDate>();
        HashMap<TripPattern, TripPatternForDate> oldTripPatternsForDate = new HashMap<TripPattern, TripPatternForDate>();
        TransferIndexGenerator transferIndexGenerator = null;
        if (OTPFeature.TransferConstraints.isOn()) {
            transferIndexGenerator = realtimeTransitLayer.getTransferIndexGenerator();
        }
        for (Timetable timetable : updatedTimetables) {
            TripPatternForDate newTripPatternForDate;
            TripPatternForDate oldTripPatternForDate;
            LocalDate date = ServiceCalendarMapper.localDateFromServiceDate(timetable.getServiceDate());
            if (!this.tripPatternsStartingOnDateMapCache.containsKey(date)) {
                Map<TripPattern, TripPatternForDate> map = realtimeTransitLayer.getTripPatternsStartingOnDateCopy(date).stream().collect(Collectors.toMap(t -> t.getTripPattern().getPattern(), t -> t));
                this.tripPatternsStartingOnDateMapCache.put(date, map);
            }
            if ((oldTripPatternForDate = this.tripPatternsStartingOnDateMapCache.get(date).get(timetable.getPattern())) != null) {
                this.tripPatternsStartingOnDateMapCache.get(date).remove(timetable.getPattern(), oldTripPatternForDate);
                oldTripPatternsForDate.put(timetable.getPattern(), oldTripPatternForDate);
                datesToBeUpdated.addAll(oldTripPatternForDate.getRunningPeriodDates());
            }
            if ((newTripPatternForDate = tripPatternForDateMapper.map(timetable, timetable.getServiceDate())) == null) continue;
            this.tripPatternsStartingOnDateMapCache.get(date).put(timetable.getPattern(), newTripPatternForDate);
            newTripPatternsForDate.put(timetable.getPattern(), newTripPatternForDate);
            datesToBeUpdated.addAll(newTripPatternForDate.getRunningPeriodDates());
            if (transferIndexGenerator == null || !newTripPatternForDate.getTripPattern().getPattern().isCreatedByRealtimeUpdater()) continue;
            transferIndexGenerator.addRealtimeTrip(newTripPatternForDate.getTripPattern(), timetable.getTripTimes().stream().map(TripTimes::getTrip).collect(Collectors.toList()));
        }
        for (LocalDate date : datesToBeUpdated) {
            this.tripPatternsRunningOnDateMapCache.computeIfAbsent(date, p -> new HashSet<TripPatternForDate>(realtimeTransitLayer.getTripPatternsRunningOnDateCopy(date)));
            Set<TripPatternForDate> patternsForDate = this.tripPatternsRunningOnDateMapCache.get(date);
            for (Map.Entry entry : oldTripPatternsForDate.entrySet()) {
                TripPattern tripPattern = (TripPattern)entry.getKey();
                TripPatternForDate oldTripPatternForDate = (TripPatternForDate)oldTripPatternsForDate.get(tripPattern);
                if (oldTripPatternForDate == null || !oldTripPatternForDate.getRunningPeriodDates().contains(date)) continue;
                patternsForDate.remove(oldTripPatternForDate);
            }
            for (Map.Entry entry : newTripPatternsForDate.entrySet()) {
                TripPatternForDate newTripPatternForDate = (TripPatternForDate)entry.getValue();
                if (newTripPatternForDate == null || !newTripPatternForDate.getRunningPeriodDates().contains(date)) continue;
                patternsForDate.add(newTripPatternForDate);
            }
            realtimeTransitLayer.replaceTripPatternsForDate(date, new ArrayList<TripPatternForDate>(patternsForDate));
        }
        if (transferIndexGenerator != null) {
            transferIndexGenerator.generateTransfers();
        }
        this.graph.setRealtimeTransitLayer(realtimeTransitLayer);
        LOG.debug("UPDATING {} tripPatterns took {} ms", (Object)updatedTimetables.size(), (Object)(System.currentTimeMillis() - startTime));
    }
}

