/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import com.google.common.collect.ArrayListMultimap;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.StopIndexForRaptor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.Transfer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternForDate;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripPatternWithRaptorStopIndexes;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.constrainedtransfer.TransferIndexGenerator;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransfersMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TripPatternForDateMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TripPatternMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.request.RaptorRequestTransferCache;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitLayerMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TransitLayerMapper.class);
    private final Graph graph;

    private TransitLayerMapper(Graph graph) {
        this.graph = graph;
    }

    public static TransitLayer map(TransitTuningParameters tuningParameters, Graph graph) {
        return new TransitLayerMapper(graph).map(tuningParameters);
    }

    private TransitLayer map(TransitTuningParameters tuningParameters) {
        LOG.info("Mapping transitLayer from Graph...");
        StopIndexForRaptor stopIndex = new StopIndexForRaptor(this.graph.index.getAllStops(), tuningParameters);
        Collection<TripPattern> allTripPatterns = this.graph.tripPatternForId.values();
        TripPatternMapper tripPatternMapper = new TripPatternMapper();
        Map<TripPattern, TripPatternWithRaptorStopIndexes> newTripPatternForOld = tripPatternMapper.mapOldTripPatternToRaptorTripPattern(stopIndex, allTripPatterns);
        HashMap<LocalDate, List<TripPatternForDate>> tripPatternsByStopByDate = this.mapTripPatterns(allTripPatterns, newTripPatternForOld);
        List<List<Transfer>> transferByStopIndex = TransfersMapper.mapTransfers(stopIndex, this.graph.transfersByStop);
        TransferIndexGenerator transferIndexGenerator = null;
        if (OTPFeature.TransferConstraints.isOn()) {
            transferIndexGenerator = new TransferIndexGenerator(this.graph.getTransferService().listAll(), newTripPatternForOld.values(), stopIndex);
            transferIndexGenerator.generateTransfers();
        }
        RaptorRequestTransferCache transferCache = new RaptorRequestTransferCache(tuningParameters.transferCacheMaxSize());
        LOG.info("Mapping complete.");
        return new TransitLayer(tripPatternsByStopByDate, transferByStopIndex, this.graph.getTransferService(), stopIndex, this.graph.getTimeZone().toZoneId(), transferCache, tripPatternMapper, transferIndexGenerator);
    }

    private HashMap<LocalDate, List<TripPatternForDate>> mapTripPatterns(Collection<TripPattern> allTripPatterns, Map<TripPattern, TripPatternWithRaptorStopIndexes> newTripPatternForOld) {
        TripPatternForDateMapper tripPatternForDateMapper = new TripPatternForDateMapper(this.graph.index.getServiceCodesRunningForDate(), newTripPatternForOld);
        Set<ServiceDate> allServiceDates = this.graph.index.getServiceCodesRunningForDate().keySet();
        List<TripPatternForDate> tripPatternForDates = Collections.synchronizedList(new ArrayList());
        allServiceDates.parallelStream().forEach(serviceDate -> {
            ArrayList<TripPatternForDate> values = new ArrayList<TripPatternForDate>();
            for (TripPattern oldTripPattern : allTripPatterns) {
                TripPatternForDate tripPatternForDate = tripPatternForDateMapper.map(oldTripPattern.getScheduledTimetable(), (ServiceDate)serviceDate);
                if (tripPatternForDate == null) continue;
                values.add(tripPatternForDate);
            }
            if (!values.isEmpty()) {
                tripPatternForDates.addAll(values);
            }
        });
        return this.keyByRunningPeriodDates(tripPatternForDates);
    }

    static List<TripTimes> getSortedTripTimes(Timetable timetable) {
        return timetable.getTripTimes().stream().sorted(Comparator.comparing(TripTimes::sortIndex)).collect(Collectors.toList());
    }

    private HashMap<LocalDate, List<TripPatternForDate>> keyByRunningPeriodDates(List<TripPatternForDate> tripPatternForDates) {
        ArrayListMultimap multiMap = ArrayListMultimap.create();
        for (TripPatternForDate tripPatternForDate : tripPatternForDates) {
            for (LocalDate date : tripPatternForDate.getRunningPeriodDates()) {
                multiMap.put((Object)date, (Object)tripPatternForDate);
            }
        }
        HashMap<LocalDate, List<TripPatternForDate>> result = new HashMap<LocalDate, List<TripPatternForDate>>();
        for (Map.Entry entry : multiMap.asMap().entrySet()) {
            result.put((LocalDate)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        return result;
    }
}

