/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDate;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.model.calendar.ServiceDate;

class ServiceCalendarMapper {
    ServiceCalendarMapper() {
    }

    static Multimap<LocalDate, Integer> mapServiceCodesByLocalDates(CalendarService calendarService, Map<FeedScopedId, Integer> serviceCodes) {
        HashMultimap serviceCodesByLocalDates = HashMultimap.create();
        if (calendarService != null) {
            for (FeedScopedId serviceId : calendarService.getServiceIds()) {
                Set localDates = calendarService.getServiceDatesForServiceId(serviceId).stream().map(ServiceCalendarMapper::localDateFromServiceDate).collect(Collectors.toSet());
                int serviceIndex = serviceCodes.get(serviceId);
                for (LocalDate date : localDates) {
                    serviceCodesByLocalDates.put((Object)date, (Object)serviceIndex);
                }
            }
        }
        return serviceCodesByLocalDates;
    }

    static LocalDate localDateFromServiceDate(ServiceDate serviceDate) {
        return LocalDate.of(serviceDate.getYear(), serviceDate.getMonth(), serviceDate.getDay());
    }
}

