/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.opentripplanner.model.plan.pagecursor.PageCursor;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.SlackProvider;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.transit.raptor.api.request.DebugRequestBuilder;
import org.opentripplanner.transit.raptor.api.request.Optimization;
import org.opentripplanner.transit.raptor.api.request.RaptorProfile;
import org.opentripplanner.transit.raptor.api.request.RaptorRequest;
import org.opentripplanner.transit.raptor.api.request.RaptorRequestBuilder;
import org.opentripplanner.transit.raptor.api.request.SearchParamsBuilder;
import org.opentripplanner.transit.raptor.api.transit.RaptorTransfer;
import org.opentripplanner.transit.raptor.rangeraptor.SystemErrDebugLogger;
import org.opentripplanner.util.OTPFeature;

public class RaptorRequestMapper {
    private final RoutingRequest request;
    private final Collection<? extends RaptorTransfer> accessPaths;
    private final Collection<? extends RaptorTransfer> egressPaths;
    private final long transitSearchTimeZeroEpocSecond;

    private RaptorRequestMapper(RoutingRequest request, Collection<? extends RaptorTransfer> accessPaths, Collection<? extends RaptorTransfer> egressPaths, long transitSearchTimeZeroEpocSecond) {
        this.request = request;
        this.accessPaths = accessPaths;
        this.egressPaths = egressPaths;
        this.transitSearchTimeZeroEpocSecond = transitSearchTimeZeroEpocSecond;
    }

    public static RaptorRequest<TripSchedule> mapRequest(RoutingRequest request, ZonedDateTime transitSearchTimeZero, Collection<? extends RaptorTransfer> accessPaths, Collection<? extends RaptorTransfer> egressPaths) {
        return new RaptorRequestMapper(request, accessPaths, egressPaths, transitSearchTimeZero.toEpochSecond()).doMap();
    }

    private RaptorRequest<TripSchedule> doMap() {
        RaptorRequestBuilder builder = new RaptorRequestBuilder();
        SearchParamsBuilder searchParams = builder.searchParams();
        if (this.request.pageCursor == null) {
            int time = this.relativeTime(this.request.getDateTime());
            if (this.request.arriveBy) {
                searchParams.latestArrivalTime(time);
            } else {
                searchParams.earliestDepartureTime(time);
            }
            searchParams.searchWindow(this.request.searchWindow);
        } else {
            PageCursor c = this.request.pageCursor;
            if (c.earliestDepartureTime != null) {
                searchParams.earliestDepartureTime(this.relativeTime(c.earliestDepartureTime));
            }
            if (c.latestArrivalTime != null) {
                searchParams.latestArrivalTime(this.relativeTime(c.latestArrivalTime));
            }
            searchParams.searchWindow(c.searchWindow);
        }
        if (this.request.maxTransfers != null) {
            searchParams.maxNumberOfTransfers(this.request.maxTransfers);
        }
        builder.profile(RaptorProfile.MULTI_CRITERIA).enableOptimization(Optimization.PARETO_CHECK_AGAINST_DESTINATION).slackProvider(new SlackProvider(this.request.transferSlack, this.request.boardSlack, this.request.boardSlackForMode, this.request.alightSlack, this.request.alightSlackForMode));
        builder.searchParams().timetableEnabled(this.request.timetableView).constrainedTransfersEnabled(OTPFeature.TransferConstraints.isOn()).addAccessPaths(this.accessPaths).addEgressPaths(this.egressPaths);
        if (this.request.raptorDebuging != null) {
            DebugRequestBuilder debug = builder.debug();
            SystemErrDebugLogger debugLogger = new SystemErrDebugLogger(true);
            debug.addStops(this.request.raptorDebuging.stops()).setPath(this.request.raptorDebuging.path()).debugPathFromStopIndex(this.request.raptorDebuging.debugPathFromStopIndex()).stopArrivalListener(debugLogger::stopArrivalLister).patternRideDebugListener(debugLogger::patternRideLister).pathFilteringListener(debugLogger::pathFilteringListener).logger(debugLogger);
        }
        if (!this.request.timetableView && this.request.arriveBy) {
            builder.searchParams().preferLateArrival(true);
        }
        return builder.build();
    }

    private int relativeTime(Instant time) {
        return (int)(time.getEpochSecond() - this.transitSearchTimeZeroEpocSecond);
    }
}

