/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import java.util.Arrays;
import java.util.Map;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.McCostParams;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.cost.McCostParamsBuilder;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.request.StreetMode;

public class McCostParamsMapper {
    public static McCostParams map(RoutingRequest request) {
        McCostParamsBuilder builder = new McCostParamsBuilder();
        builder.transferCost(request.transferCost).waitReluctanceFactor(request.waitReluctance);
        if (request.modes.transferMode == StreetMode.BIKE) {
            builder.boardCost(request.bikeBoardCost);
        } else {
            builder.boardCost(request.walkBoardCost);
        }
        builder.transitReluctanceFactors(McCostParamsMapper.mapTransitReluctance(request.transitReluctanceForMode()));
        return builder.build();
    }

    public static double[] mapTransitReluctance(Map<TransitMode, Double> map) {
        if (map.isEmpty()) {
            return null;
        }
        double[] transitReluctance = new double[TransitMode.values().length];
        Arrays.fill(transitReluctance, 1.0);
        for (TransitMode mode : map.keySet()) {
            transitReluctance[mode.ordinal()] = map.get((Object)mode);
        }
        return transitReluctance;
    }
}

