/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public class DateMapper {
    public static ZonedDateTime asStartOfService(ZonedDateTime date) {
        return date.truncatedTo(ChronoUnit.HOURS).withHour(12).minusHours(12L);
    }

    public static ZonedDateTime asStartOfService(Instant time, ZoneId zoneId) {
        LocalDate date = LocalDate.ofInstant(time, zoneId);
        return DateMapper.asStartOfService(date, zoneId);
    }

    public static ZonedDateTime asStartOfService(LocalDate localDate, ZoneId zoneId) {
        return ZonedDateTime.of(localDate, LocalTime.NOON, zoneId).minusHours(12L);
    }

    public static int secondsSinceStartOfTime(ZonedDateTime timeZero, LocalDate localDate) {
        ZonedDateTime startOfDay = DateMapper.asStartOfService(localDate, timeZero.getZone());
        return (int)Duration.between(timeZero, startOfDay).getSeconds();
    }

    public static int secondsSinceStartOfTime(ZonedDateTime startOfTime, Instant instant) {
        return (int)Duration.between(startOfTime.toInstant(), instant).getSeconds();
    }

    public static LocalDateTime asDateTime(LocalDate localDate, int secondsSinceStartOfDay) {
        return localDate.atStartOfDay().plusSeconds(secondsSinceStartOfDay);
    }

    public static int secondsSinceStartOfService(ZonedDateTime departureDate, ZonedDateTime dateTime, ZoneId zoneId) {
        ZonedDateTime startOfService = DateMapper.asStartOfService(departureDate.toLocalDate(), zoneId);
        return (int)Duration.between(startOfService, dateTime).toSeconds();
    }
}

